/*
 * Created on 08.12.2003 14:57:47
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package generation;

import mauda.*;
import mauda.generation.*;
import mauda.plugin.*;
import mauda.utils.Prop;

import jedas.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
/**
 * pane for editing the ratings of suboperations
 * 
 * @author Markus Krebs
 */
public class RatingTab extends EditTab implements ListSelectionListener {
	
	protected String ratingFilename = "rating.xml";	// Dateiname fr Laden/Speichern

	private JList list;
	private Vector idVector;
	
	protected static final String tabName = "Rating";
	protected static final String load = "Load";
	protected static final String save = "Save";
	protected static final String change = "Change";

	protected static final String changeMessageTitle = "ChangeMessageTitle";	
	
	/**
	 * Constructs a panel to view the suboperations an the
	 * corresponding rating-value.
	 * @param exercise GenExercise
	 */
	public RatingTab(GenExercise exercise) {
		super(exercise);
		
		setTabName(tabName);

		updateSettings();
		
		// Bemerkung: Ratings werden bereits beim PlugInHandler geladen!
		//loadConfig(ratingFilename);	// Muss natrlich nach getRatings stehen
				
		idVector = new Vector();
		
		list = new JList(new Vector());
		list.addListSelectionListener(this);
		setTopPanel(new JScrollPane(list));
		
		// Button-Teil
		createButton(load);
		createButton(save);
		createButton(change);
	}
	protected void doUpdate() {
		updateLists();
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(!exercise.actionsAllowed()) return;

		OperationExecuter oe = SimpleExercise.getOperationExecuter();
		Ratings ratings = oe.getRatings();

		String s = e.getActionCommand();
		if(s == change) {
			int index = list.getSelectedIndex();
			if (index < 0) return;
			String key = (String)idVector.elementAt(index);
			int value = ((Integer)ratings.get(key)).intValue();
			JPanel inputPanel = new JPanel();
			JLabel keyLabel = new JLabel(key);
			inputPanel.add(keyLabel);
			JTextField valueTextField = new JTextField(value+"",3);
			inputPanel.add(valueTextField);
			int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(),
								inputPanel, 
								Prop.get(this, "Rating"+changeMessageTitle),
								JOptionPane.OK_CANCEL_OPTION);
			if(result == JOptionPane.OK_OPTION) {
				int newValue = Integer.parseInt(valueTextField.getText());
				ratings.put(key, new Integer(newValue));
				update();
			}
		} else if(s == load) {
			if(dialog("LOAD "+dataFilename)) {
				loadConfig(dataFilename);
				update();
			}
		} else if(s == save) {
			if(dialog("SAVE "+dataFilename)) {
				Vector savevev = new Vector();
				savevev.add(ratings.save());
				boolean result = XMLFileAccess.save(dataFilename, savevev);
				if(!result) JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant save file: '"+dataFilename+"' !\n\n"+
										"--> File not saved!");
			}
			
		}
		//update();
	}
	protected void loadConfig(String filename) {
		Vector v = XMLFileAccess.load(dataFilename);
		OperationExecuter oe = SimpleExercise.getOperationExecuter();
		Ratings ratings = oe.getRatings();
		if(v==null) {
			// Dieser Fall sollte eigentlich nie vorkommen, da
			// der PlugInHandler eine rating.xml erzeugt, wenn
			// es keine gibt.
			JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Cant load '"+filename+"'!");
			return;
		} 
		ratings.load((Vector)v.firstElement());
	}

	/* (non-Javadoc)
	 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
	 */
	public void valueChanged(ListSelectionEvent e) {
		if(true) return;
		int index = ((JList)e.getSource()).getSelectedIndex();
		if(index==-1) return;
		String msg = "OK";
		JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), msg);
		//((JList)e.getSource()).clearSelection();
	}

	protected void updateLists() {
		OperationExecuter oe = SimpleExercise.getOperationExecuter();
		Ratings ratings = oe.getRatings();
		int size = ratings.size();
		String[] sarr = new String[size];
		Iterator it = ratings.keySet().iterator();
		int c = 0;
		while(it.hasNext()) {
			sarr[c] = (String)it.next();
			c++;
		}
		Arrays.sort(sarr, new Comparator() {
			public int compare(Object o1, Object o2) {
				return ((String)o1).compareTo((String)o2);
			}
			//public boolean equals(Object o) {
			//	return false;
			//}
			});
		
		Vector listData = new Vector();
		for(int i=0; i<sarr.length; i++) {
			String key = sarr[i];
			int value = ((Integer)ratings.get(key)).intValue();			
			listData.add(key+" = "+value);
			idVector.add(key);
		}
		/*
		Vector listData = new Vector();
		idVector.removeAllElements();
		Iterator it = ratings.keySet().iterator();
		while(it.hasNext()) {
			String key = (String)it.next();
			int value = ((Integer)ratings.get(key)).intValue();
			listData.add(key+" = "+value);
			idVector.add(key);
		}*/

		list.setListData(listData);

		Jedas.updateDisplay();
	}
	protected void updateSettings() {
		super.updateSettings();
		setDataFilename(ratingFilename);
		//loadConfig(dataFilename);	// <-- wird bereits vom PlugInHandler erledigt	
	}
}
