/*
 * Created on 15.01.2004 12:35:58
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda;

/**
 * Holds the different modes for exercises and maps them to
 * strings and vice versa.
 * 
 * @author Markus Krebs
 */
public class ExerciseMode {
	/**
	 * NormalMode
	 */
	public static final int NORMAL = 0;
	/**
	 * FaultMode
	 */
	public static final int FAULT = 1;
	/**
	 * UnknownMode
	 */
	public static final int UNKNOWN = -1;
	
	/**
	 * Gets for a mode-string the corresponding mode-ID
	 * @param mode Mode as string
	 * @return id of the mode
	 */
	public static int getID(String mode) {
		if(mode==null) return UNKNOWN;
		if(mode.equals("NORMAL")) return NORMAL;
		else if(mode.equals("FAULT")) return FAULT;
		else return UNKNOWN;
	}
	/**
	 * Gets for a mode-ID the corresponding mode-string, which
	 * is used for saving-purposes.
	 * @param mode mode-ID
	 * @return A string-representation of the mode-ID
	 */
	public static String getString(int mode) {
		if(mode == NORMAL) return "NORMAL";
		if(mode == FAULT) return "FAULT";
		else return "UNKNOWN";
	}
	/**
	 * Gets for a mode-ID the corresponding mode-string. The
	 * difference to <code>getString</code> is, that this string
	 * is used in GUIS, e.g. menus or buttons.
	 * @param mode mode-ID
	 * @return A string-representation of the mode-ID
	 */
	public static String getGUIString(int mode) {
		if(mode == NORMAL) return "Normal";
		if(mode == FAULT) return "Fault";
		else return "unknown";		
	}
}
