/*
 * Created on 19.03.2004 15:22:31
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.evaluation;

import mauda.Exercise;
import mauda.ExerciseUpdateEvent;
import mauda.ExerciseUpdateListener;
import mauda.operation.*;
//import mauda.undoredo.UndoRedoInfo;

import javax.swing.*;
import java.awt.*;
import java.util.*;

/**
 * Panel for viewing comments for operations used in Evaluation-
 * Editor and -Player.
 * 
 * @author Markus Krebs
 */
public class CommentView implements ExerciseUpdateListener {
	
	private Exercise exercise;

	private boolean finishedLoading;
	
	//private UndoRedoInfo undoRedoInfo;	// Real Undo/Redo Wird nicht bentigt
	
	private Vector commentObjects;
	private int position;
	
	private JPanel panel;
	private JTextPane editorPane;
	/**
	 * Creates a CommentView
	 * @param exercise Exercise
	 */
	public CommentView(Exercise exercise) {
		super();
		this.exercise = exercise;
		finishedLoading = false;
		
		panel = new JPanel();
		panel.setLayout(new BorderLayout());
		
		editorPane = new JTextPane();
		editorPane.setEditable(true);
		WrapPanel wrapPanel = new WrapPanel(editorPane, true);
		JScrollPane sp = new JScrollPane(wrapPanel);
		//sp.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		panel.add(sp, BorderLayout.CENTER);		
		
		//undoRedoInfo = new UndoRedoInfo();
		
		commentObjects = new Vector();
		position = -1;
		initComments();
	}

	/* (non-Javadoc)
	 * @see mauda.ExerciseUpdateListener#exerciseUpdate(mauda.ExerciseUpdateEvent)
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e) {
		if(e.getID() == ExerciseUpdateEvent.FINISHED_LOADING) {
			finishedLoading = true;
			showComment();
			return;
		}
		if(!finishedLoading) return;
		
		
		if(e.getID() == ExerciseUpdateEvent.START_OF_EXECUTION) {
			storeActualComment();
			position++;
			showComment();
		}
		
		if(!e.dsChanged()) return;
		storeActualComment();
		switch(e.getID()) {
			case ExerciseUpdateEvent.OPERATION_EXECUTED :
				//position++;	// wird oben bei START_OF_EXECUTION erledigt
				interactiveEvent(e.getOperation());
				break;
			case ExerciseUpdateEvent.BACK :
				position--;
				showComment();
				break;
			case ExerciseUpdateEvent.FORWARD :
				position++;
				showComment();
				break;
			//case ExerciseUpdateEvent.UNDO :
			//	undoRedoInfo.undo(commentObjects);
			//	showComment();
			//	break;
			//case ExerciseUpdateEvent.REDO :
			//	undoRedoInfo.redo(commentObjects);
			//	showComment();
			//	break;
			case ExerciseUpdateEvent.RESET:
				finishedLoading = false;
				position=-1;
				initComments();
				break;
			case ExerciseUpdateEvent.JUMP :
				position += e.getValue();
				showComment();
				break;
			default :
				break;
		}
	}
	private void initComments() {
		commentObjects.removeAllElements();
		// Wurzelkommentar erlauben => spter bei "position" immer "+1" machen!
		Vector newv = new Vector();
		newv.add("Beginning of Exercise\n\n");
		//undoRedoInfo.clear(newv);
		commentObjects.addAll(newv);
		showComment();
	}
	private void interactiveEvent(SimpleOperation so) {
		//undoRedoInfo.storeChange(position+1, commentObjects, "Comment for: "+so.out()+"\n\n");
		if(position+1>=commentObjects.size())
			commentObjects.add("Comment for: "+so.out()+"\n\n");
		showComment();
	}
	private void showComment() {
		if(position<-1) return;
		if(position+1>=commentObjects.size()) return;
		String comment = (String)commentObjects.elementAt(position+1);
		//System.out.println("CommentView.showComment(): "+comment);
		editorPane.setText(comment);
	}
	private void storeActualComment() {
		if(position<-1) return;
		if(position+1>=commentObjects.size()) return;
		String comment = editorPane.getText();
		commentObjects.setElementAt(comment, position+1);
	}
	
	/**
	 * Method for retrieving the panel for the CommentView
	 * @return Returns the panel
	 */
	public JPanel getPanel() { return panel; }
	
	/**
	 * Converts the comments in an appropriate format, that can
	 * be saved to an xml-file
	 * @return A Vector representation of the comments
	 */
	public Vector save() {
		storeActualComment();
		return (Vector)commentObjects.clone();
	}
	/**
	 * Converts a vector that contains the comments readed from a
	 * xml-file, and converts it for the view specific
	 * representation
	 * @param v The vector from the xml-file
	 */
	public void load(Vector v) {
		commentObjects = (Vector)v.clone();
	}

}
