/*
 * Created on 23.03.2004 11:46:57
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.evaluation;

import java.util.HashMap;
import java.util.Vector;
/**
 * Stores time-stamp-information for a specific operation, and is
 * needed in Evaluation-Editor and Evaluation-Player
 * 
 * @author Markus Krebs
 */
public class OpTimeStamp {
	
	private Vector timeStamps; // Abwechselndes speichern von Start/Stop-Zeiten

	/**
	 * Creates a new time-stamp
	 */
	public OpTimeStamp() {
		timeStamps = new Vector();
	}
	
	/**
	 * Adds a start-timestamp to the current timestamps of this operation.
	 * @param s time-stamp
	 */
	public void addStart(long s) {
		//if(timeStamps.size()%2 == 1) return;
		timeStamps.add(new Long(s));
		//System.out.println("OpTimeStamp.addStart(..): "+s);
	}
	/**
	 * Adds a stop-timestamp to the current timestamps of this operation.
	 * @param s time-stamp
	 */
	public void addStop(long s) {
		//if(timeStamps.size()%2 == 0) return;
		timeStamps.add(new Long(s));
		//System.out.println("OpTimeStamp.addStop(..): "+s);
	}
	
	/**
	 * Returns the time-stamps of this operation. The timestamps are alternated
	 * between start and stop. This means that the first time-stamp is a
	 * start-time-stamp, the second is a stop-time-stamp, the third is again a start-
	 * time-stamp, ... and so on.
	 * @return TimeStamps
	 */
	public Vector getTimeStamps() {
		return timeStamps;
	}
	
	/**
	 * Clears all time-stamps that are associated with this operation.
	 */
	public void clear() {
		timeStamps.removeAllElements();
		//System.out.println("OpTimeStamp.clear()");
	}
	
	/**
	 * Gets the first start-time
	 * @return start-time
	 */
	public long getStart() { return ((Long)timeStamps.firstElement()).longValue(); }
	
	/**
	 * Gets the last stop-time
	 * @return stop-time
	 */
	public long getStop() { return ((Long)timeStamps.lastElement()).longValue(); }

	/**
	 * Converts this time-stamp in saveable representation for
	 * storage in a xml-file.
	 * @return A HashMap-representation
	 */
	public HashMap save() {
		HashMap hm = new HashMap();
		hm.put("TimeStamps", timeStamps);
		//hm.put("Start", new Long(start));
		//hm.put("Stop", new Long(stop));
		//System.out.println("OpTimeStamp.save(): "+start+" - "+stop);
		return hm;
	}
	/**
	 * Loads this time-stamp with the parameter from the HashMap-
	 * representation, which was stored in a xml-file.
	 * @param hm HashMap from xml-file
	 */
	public void load(HashMap hm) {
		timeStamps = (Vector)hm.get("TimeStamps");
		//start = ((Long)hm.get("Start")).longValue();
		//stop = ((Long)hm.get("Stop")).longValue();
	}
}
