/*
 * Created on 26.02.2004 17:53:38
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback.types;

import mauda.*;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.feedback.select.FeedbackSelector;
import mauda.operation.*;

import java.util.HashMap;

/**
 * Provides the logic for <i>NoTutor (no feedback)</i>
 * 
 * @author Markus Krebs
 */
public class NoTutor extends SimpleFeedback {
	
	private static final int type = FeedbackSelector.NO_TUTOR;

	private static final String specialGetNext = "Get next ...";
	private static final String specialFinishEx = "Finish exercise ...";
	
	/**
	 * Creates a NoTutor-Feedback
	 * @param exercise FeedbackExercise
	 */
	public NoTutor(FeedbackExercise exercise) {
		super(exercise);
		specialState = specialGetNext;
	}
	
	protected void jumpEvent(int delta) {
		super.jumpEvent(delta);
		updateBackForwardButtons();
		//System.out.println("IF&EC: opDelta = "+opCounter);
		//System.out.println("       todoPosition = "+todoPosition);
		String msg = "";
		if(counter>=0) {
			OperationRecorder or = exercise.getOperationRecorder();
			SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
			msg = feedbackGenerator.genMessage(
							"information.gif",
							"<b>Jump</b> to "+so.out());
			exercise.setInteractiveMode(Exercise.SUBOPERATION); 
		} else {
			msg = feedbackGenerator.genMessage(
							"information.gif",
							"<b>Jump</b> to beginning");
			exercise.setInteractiveMode(Exercise.NOPOPUP); 
		}
		displayMessage("FEEDBACK", msg); 
		if(todoPosition==todoOperationQueue.length()-1) {
			setSpecialButtonText(specialFinishEx);
			specialState = specialFinishEx;
		} else {
			setSpecialButtonText(specialGetNext);
			specialState = specialGetNext;
		}
		//System.out.println("todoPosition = "+todoPosition);
		updateTaskMessage(); 
	}
	
	protected void specialPressed() {
		String msg = null;
		// EXERCISE-START
		if(specialState == specialGetNext) { // || specialState == specialFinishOp) {
			if(todoPosition>=0) checkForFailure();
			exercise.getTreeOperationView().enableJumping();
			//todoPosition++;	// wird in interactiveEvent erledigt
			//counter++;		// dito
			Operation op = (Operation)todoOperationQueue.get(todoPosition+1).clone();
			op.setExecution(false);
			msg = feedbackGenerator.genMessage(
						"explanation.gif",
						"Perform the SubOperations for:");
			msg +=	"<ul><li><b>"+op.out()+"</b></li></ul>"+
					"by pressing the right mouse button in the drawing-area, and selecting the correct suboperation."+
					"<br><br>";
			if(todoPosition+1==todoOperationQueue.length()-1) {
				msg += "When you have finished all suboperations, please click the <b><i>"+specialFinishEx+"</i></b> button to complete the exercise.";
				setSpecialButtonText(specialFinishEx);
				specialState = specialFinishEx;
			} else {
				msg += "When you have finished all suboperations, please click the <b><i>"+specialGetNext+"</i></b> button.";
				setSpecialButtonText(specialGetNext);
				//specialState = specialFinishOp;
			}
			displayMessage("FEEDBACK", msg);
			exercise.commit(op);	// <-- lst OPERATION_EXECUTED aus --> interactiveEvent
			exercise.setInteractiveMode(Exercise.SUBOPERATION);
			// -> WAIT_FOR_FIRST
			return;
		} else if(specialState == specialFinishEx) {
			finishedExercise();
			return;			
		}
	}
	protected void demandPressed() { }
	protected void forwardPressed() { exercise.forward(); }
	protected void backPressed() {
		exercise.back();
	}
	
	// =========================================================================
	protected void forwardEvent() {
		counter++;
		super.forwardEvent();
		updateBackForwardButtons();
		FeedbackObject fo = callKB();
		Object o = exercise.getOperationRecorder().getCurrentOperation();
		if(o instanceof Operation) {
			todoPosition++;
			if(todoPosition == todoOperationQueue.length()-1) {
				setSpecialButtonText(specialFinishEx);
				specialState = specialFinishEx;
			}
		} 
		String msg = feedbackGenerator.genMessage(
				"information.gif",
				"<b>Forward</b> "+((SimpleOperation)o).out());
		displayMessage("FEEDBACK", msg);
	}
	
	// =========================================================================
	protected void backEvent() {
		counter--;
		String msg;
		super.backEvent();
		updateBackForwardButtons();
		FeedbackObject fo = callKB();
		Object o = exercise.getOperationRecorder().getNextOperation();
		if(o instanceof Operation) {
			todoPosition--;
			if(todoPosition<todoOperationQueue.length()-1) {
				setSpecialButtonText(specialGetNext);
				specialState = specialGetNext;
			}
		} 
		msg = feedbackGenerator.genMessage(
				"information.gif",
				"<b>Back</b> "+((SimpleOperation)o).out());
		displayMessage("FEEDBACK", msg);
	}
	
	// =========================================================================
	protected void interactiveEvent() {
		Object o = exercise.getOperationRecorder().getCurrentOperation();
		if(o instanceof Operation) {
			todoPosition++;
			updateTaskMessage();
			updateBackForwardButtons();
			return;
		} 

		updateBackForwardButtons();
		
		String msg = feedbackGenerator.genMessage(
				"information.gif",
				"<b>Execute</b> "+((SimpleOperation)o).out());
		displayMessage("FEEDBACK", msg);

		if(differentOperation) {
			cutFirstFailureFeedbackObjects();
			checkForFailure();
		}
	}
	
	
	// =========================================================================
	
	protected void finishedLoading() {
		super.finishedLoading();
		String msg = genOpToPerformMessage();		
		msg += getFeedbackDescription();
		msg += "<br>";
		msg += "To perform the first operation, please click the <b><i>'"+specialGetNext+"'</i></b> button below.";
		displayMessage("TASK", msg);
		
		setSpecialButtonText(specialGetNext);
		setSpecialEnabled(true);
	}
	protected String getFeedbackDescription() {
		return "You will get no feedback.";
	}
	
	protected void linkClicked(String href) {
		super.linkClicked(href);
	}	
	/* (non-Javadoc)
	 * @see mauda.feedback.SimpleFeedback#getFeedbackTypeID()
	 */
	public int getFeedbackTypeID() { return type; }

	
	/* (non-Javadoc)
	 * @see mauda.feedback.SimpleFeedback#save()
	 */
	public HashMap save() {
		HashMap hm = super.save();
		return hm;
	}
	/* (non-Javadoc)
	 * @see mauda.feedback.SimpleFeedback#load(java.util.HashMap)
	 */
	public void load(HashMap hm) {
		super.load(hm);
	}
}
