/*
 * Created on 26.02.2004 17:53:38
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.feedback.types;

import mauda.*;
import mauda.feedback.FeedbackExercise;
import mauda.feedback.FeedbackObject;
import mauda.feedback.SimpleFeedback;
import mauda.feedback.select.*;
import mauda.operation.*;

/**
 * Provides the logic for <i>Solution-Feedback</i>. A Solution-Feedback is a feedback-
 * type that handles the logic for displaying a correct solution of an exercise.
 * 
 * @author Markus Krebs
 */
public class SolutionFeedback extends SimpleFeedback {
	
	private static final int type = FeedbackSelector.CHOOSE;
	
	private static final String specialGetNext = "Get next ...";
	private static final String specialFinishOp = "Finish Operation ...";
	private static final String specialFinishEx = "Finish exercise ...";
	private static final String specialPerform = "Perform correct Operation...";
	
	/**
	 * Creates an SolutionFeedback
	 * @param exercise FeedbackExercise
	 */
	public SolutionFeedback(FeedbackExercise exercise) {
		super(exercise);
		feedbackBound = Integer.MAX_VALUE;		
		exercise.setInteractiveMode(Exercise.NOPOPUP);
		setDemandEnabled(false);
		//exercise.getFeedbackPanel().hideDemandButton();
		finishedLoading = true;
		finishedExercise = true;	// damit kein Feedback-Wechsel mglich ist
	}
	
	protected void jumpEvent(int delta) {
		super.jumpEvent(delta);
		//System.out.println("IF&EC: opDelta = "+opCounter);
		//System.out.println("       todoPosition = "+todoPosition);
		if(counter>=0) {
			OperationRecorder or = exercise.getOperationRecorder();
			SimpleOperation so = (SimpleOperation)or.getCurrentOperation();
			String msg = feedbackGenerator.genMessage(
							"information.gif",
							"<b>Jump</b> to "+so.out()); 
			if(so instanceof SubOperation) {
				FeedbackObject fo = callKB();
				displayMessage("FEEDBACK", fo.getNextMessage());
			} else if (so instanceof Operation) {
				displayMessage("FEEDBACK", msg);
				todoPosition--;	// wird in interactiveEvent erhht
				counter--;		// dito
				doInteractiveEvent();
			} 
		} else {
			String msg = feedbackGenerator.genMessage(
							"information.gif",
							"<b>Jump</b> to beginning");
			displayMessage("FEEDBACK", msg);
		}
		//System.out.println("todoPosition = "+todoPosition);
		updateBackForwardButtons();
	}
	
	protected void specialPressed() { }
	protected void demandPressed() { }
	protected void forwardPressed() { exercise.forward(); }
	protected void backPressed() {
		//Object actop = exercise.getOperationRecorder().getCurrentOperation(); 
		//if(actop instanceof Operation && todoPosition==0) return;
		exercise.back();
	}
	
	// =========================================================================
	protected void forwardEvent() {
		counter++;
		super.forwardEvent();
		updateBackForwardButtons();
		FeedbackObject fo = callKB();
		Object o = exercise.getOperationRecorder().getCurrentOperation();
		String msg;
		if(o instanceof Operation) {
			todoPosition++;
			msg = feedbackGenerator.genMessage(
						"information.gif",
						"<b>Forward</b> "+((Operation)o).out());
			msg = makeNextLink(msg);
			displayMessage("FEEDBACK", msg);
		}
		else if(o instanceof SubOperation) {
			msg = fo.getNextMessage();
			displayMessage("FEEDBACK", msg);
		}
	}
	
	// =========================================================================
	protected void backEvent() {
		counter--;
		super.backEvent();
		updateBackForwardButtons();
		FeedbackObject fo = callKB();
		Object o = exercise.getOperationRecorder().getNextOperation();
		String msg;
		if(o instanceof Operation) {
			todoPosition--;
			msg = feedbackGenerator.genMessage(
					"information.gif",
					"<b>Back</b> "+((Operation)o).out());
			msg = makeNextLink(msg);
			displayMessage("FEEDBACK", msg);
		}
		else if(o instanceof SubOperation) {
			msg = fo.getNextMessage();
			displayMessage("FEEDBACK", msg);
		}
	}
	
	// =========================================================================
	protected void interactiveEvent() {
		// Beim Replay kann aktuelle Operation sein
		OperationRecorder or = exercise.getOperationRecorder();
		SimpleOperation so = (SimpleOperation)or.getCurrentOperation(); 
		if(so instanceof Operation) {
			todoPosition++;
			updateBackForwardButtons();
			return;			
		}
		updateBackForwardButtons();

		// Jetzt kann aktuelle Operation nur eine SubOperation sein
		FeedbackObject fo = callKB();
		String msg = fo.getNextMessage();
		displayMessage("FEEDBACK", msg);
		
		FeedbackObject temp = currentFeedbackObject;
		  
		//if(differentOperation) {
		//	cutFirstFailureFeedbackObjects();
		//	checkForFailure();
		//}
		
		currentFeedbackObject = temp;
	}	
	
	// =========================================================================
	

	protected void finishedLoading() {
		super.finishedLoading();
	}
	protected String getFeedbackDescription() {
		return "You will get an immediate feedback at any point in this correct solution.";
	}
	
	protected void linkClicked(String href) {
		super.linkClicked(href);
	}
	
	/* (non-Javadoc)
	 * @see mauda.feedback.SimpleFeedback#getFeedbackTypeID()
	 */
	public int getFeedbackTypeID() { return type; }

}
