/*
 * Created on 18.12.2003 18:41:52
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.operation;

import java.util.Comparator;
/**
 * The super-class of Operation and SubOperation
 * 
 * @author Markus Krebs
 */
public class SimpleOperation implements Comparator {
	
	protected String id;	// Operation: siehe Konstanten von oben
	protected int param1;
	protected int param2;

	/**
	 * Value for non-filled parameters, like it is in DELETE-MIN
	 * the case.
	 */
	public static final int NULL = -Integer.MIN_VALUE;	// fr leere Parameter

	/**
	 * Creates a SimpleOperation
	 * @param o ID
	 * @param p1 1st parameter
	 * @param p2 2st parameter
	 */
	public SimpleOperation(String o, int p1, int p2) {
		id = o;
		param1 = p1;
		param2 = p2;
	}

	/**
	 * Gets the ID
	 * @return ID
	 */
	public String getID() { return id; }
	/**
	 * Gets the 1st parameter
	 * @return 1st parameter
	 */
	public int getParameter1() { return param1; }
	/**
	 * Gets the 2nd parameter
	 * @return 2nd parameter
	 */
	public int getParameter2() { return param2; }

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	// 2 Operations vergleichen
	// sind gleich, wenn Type und Parameter gleich sind
	// wird bentigt, fr z.B. tries_vector.contains(Op)
	public boolean equals(Object o) {
		SimpleOperation op = (SimpleOperation)o;
		return  id.equals(op.getID()) &&
				param1 == op.getParameter1() &&
				param2 == op.getParameter2();
	}
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	// grer / kleiner -Vergleich macht hier keinen Sinn
	// und wird auch nirgends bentigt
	// ==> immer als gleich zurckgeben
	// Rating-Vergleich wird bei Operation/SubOperation
	// ber compareTo() erledigt
	public int compare(Object o1, Object o2) {
		return 0;
	}
	
	/**
	 * Executes an operation on the data-structure.
	 * @param o data-structure
	 */
	public void execute(Object o) {
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		return null;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return "Op="+id+" | param1="+param1+" | param2="+param2;
	}
	/**
	 * Creates a string-representation of this operation, that can
	 * be used in GUIs. E.g.: In feedback-messages
	 * @return string-representation
	 */
	public String out() {
		String s = id;
		if(param1!=NULL) s+=" "+(param1<10?" ":"")+param1;
		if(param2!=NULL) s+=" "+(param2<10?" ":"")+param2;
		return s;				
	}
	/**
	 * Creates a string-representation of this operation for saving-
	 * purposes.
	 * @return string-representation
	 */
	public String save() { return ""; }
	/**
	 * Loads this operation from a string-representation
	 * @param opString string-representation
	 */
	public void load(String opString) { }
}
