/*
 * Created on 14.12.2003 17:27:18
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.operation;

import java.util.*;
/**
 * Storage of a sub-operation (e.g. FibHeap -> link) with at
 * most 2 parameters.
 * 
 * @author Markus Krebs
 */
public class SubOperation extends SimpleOperation {
	/**
	 * Creates a SubOperation
	 */
	public SubOperation() {
		super(null, NULL, NULL);
	}
	/**
	 * Creates a SubOperation
	 * @param id suboperation-ID
	 */
	public SubOperation(String id) {
		super(id, NULL, NULL);
	}
	/**
	 * Creates a SubOperation from an ID with one parameter
	 * @param id suboperation-ID
	 * @param param1 1st parameter
	 */
	public SubOperation(String id, int param1) {
		super(id, param1, NULL);
	}
	/**
	 * Creates a SubOperation from an ID with two parameters
	 * @param id suboperation-ID
	 * @param param1 1st parameter
	 * @param param2 2nd parameter
	 */
	public SubOperation(String id, int param1, int param2) {
		super(id, param1, param2);
	}
	/* (non-Javadoc)
	 * @see mauda.operation.SimpleOperation#execute(java.lang.Object)
	 */
	public void execute(Object o) {
		mauda.SimpleExercise.getOperationExecuter().execute(this, o);
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() {
		return new SubOperation(id, param1, param2);
	}
	/* (non-Javadoc)
	 * @see mauda.operation.SimpleOperation#load(java.lang.String)
	 */
	public void load(String opString) {
		id = null;
		param1 = NULL;
		param2 = NULL;
		StringTokenizer st = new StringTokenizer(opString);
		String s = st.nextToken();
		id = s;
		if(st.hasMoreTokens())
			param1 = Integer.parseInt(st.nextToken()); 			
		if(st.hasMoreTokens())
			param2 = Integer.parseInt(st.nextToken()); 	
	}
	/* (non-Javadoc)
	 * @see mauda.operation.SimpleOperation#save()
	 */
	public String save() {
		String s = id;
		if(param1!=NULL) s+=" "+param1;
		if(param2!=NULL) s+=" "+param2;
		return s;
	}
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	// fr Ausgabe-Zwecke
	public String toString() {
		String s = id.toLowerCase();
		if(param1!=NULL) s+=" "+(param1<10?" ":"")+param1;
		if(param2!=NULL) s+=" "+(param2<10?" ":"")+param2;
		return s;
	}
	/* (non-Javadoc)
	 * @see mauda.operation.SimpleOperation#out()
	 */
	public String out() {
		return toString();
	}
}
