/*
 * Created on 05.01.2004 15:08:13
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin;

import mauda.operation.*;

/**
 * Interface for automatic generation of exercises. All
 * generators must implement this interface.
 * 
 * @author Markus Krebs
 */
public interface Analysable {
	/**
	 * Calculates all possible different Operation's at the current-state 
	 * of the data-structure. In the case of FibHeap from each
	 * intervall, defined by the current values, one Operation will
	 * be returned.
	 * @param o data-structure
	 * @return OperationQueue
	 */
	public OperationQueue getOperations(Object o);
	/**
	 * Calculates operations to initialize a data-structure
	 * @param o data-structure
	 * @param givenOperations OperationQueue that contains the candidates for initializing (Parameters not defined)
	 * @param difficulty difficulty-ID
	 * @param mode exercise-mode (NORMAL vs. FAULT)
	 * @return The instanciated Operations from the given Operations, what means that the parameters from givenOperations are filled
	 */
	public OperationQueue init(Object o, OperationQueue givenOperations, int difficulty, int mode);
	/**
	 * Calculates operations to scramble the current data-structure
	 * @param o data-structure
	 * @param givenOperations OperationQueue of Operations without parameters
	 * @param difficulty difficulty-ID
	 * @param mode exercise-mode (NORMAL vs. FAULT)
	 * @return Intanciated Operations (parameters filled)
	 */
	public OperationQueue scramble(Object o, OperationQueue givenOperations, int difficulty, int mode);
	/**
	 * Calculates the todo-operations for the current data-structure
	 * @param o data-structure
	 * @param givenOperations OperationQueue of Operations without parameters
	 * @param difficulty difficulty-ID
	 * @param mode exercise-mode (NORMAL vs. FAULT)
	 * @return todo-operations
	 */
	public OperationQueue autoGen(Object o, OperationQueue givenOperations, int difficulty, int mode);
	/**
	 * Generates a complete exercise from the given parameters.<br>
	 * This methods calls init, scramble and autoGen to generate
	 * the exercise.
	 * @param o data-structure.
	 * @param init OperationQueue used for initializing
	 * @param scramble OperationQueue used for scrambling
	 * @param autoGen OperationQueue used to generate the todo-operations
	 * @param difficulty difficulty-ID
	 * @param mode exercise-mode (NORMAL vs. FAULT)
	 * @return init-operations and todo-operations as a 2-dim Array (1st init, 2nd todo)
	 */
	public OperationQueue[] fullAutomatic(Object o, OperationQueue init, OperationQueue scramble, OperationQueue autoGen, int difficulty, int mode);
}
