/*
 * Created on 01.12.2003
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin;

//import mauda.MAUDA;
import mauda.operation.*;

/**
 * The central class, to access different exercise-generators.
 * 
 * @author Markus Krebs
 */
public class GeneralAnalyst {
	
	/**
	 * The current analyzer
	 */
	public static Analysable analyzer; //= new FibHeapAnalyse();
	
	/**
	 * The key-range for data-structures
	 */
	public static final int maxKey = 100; // Hchste Zahl eines Schlssels

	//public static long calcTime = 0;
	//public static int calcCount = 0;
	//public static int keysCount = 0;
	
	/**
	 * Sets the current analyzer
	 * @param a Analysable
	 */
	public static void setAnalyzer(Analysable a) {
		analyzer = a;
	}

	/**
	 * Gets all possible logical different Operations
	 * @param o data-structure
	 * @return OperationQueue of possible operations
	 * @see mauda.plugin.Analysable#getOperations(Object)
	 */
	// Mgliche verschiedene Operationen zurckgeben
	public static OperationQueue getOperations(Object o) {
		OperationQueue oq = null;
		oq = analyzer.getOperations(o);
		return oq;
	}
	/**
	 * Generates the initializing operations
	 * @param o
	 * @param givenOperations
	 * @param difficulty
	 * @param mode
	 * @return OperationQueue
	 * @see mauda.plugin.Analysable#init(Object, OperationQueue, int, int)
	 */
	// Initialisierung einer Aufgabe
	public static OperationQueue init(Object o, OperationQueue givenOperations, int difficulty, int mode) {
		OperationQueue oq = new OperationQueue();
		if(givenOperations.length()==0) return oq;
		oq = analyzer.init(o, givenOperations, difficulty, mode);
		return oq;		
	}
	/**
	 * Scrambles the current data-structure
	 * @param o
	 * @param givenOperations
	 * @param difficulty
	 * @param mode
	 * @return OperationQueue
	 * @see mauda.plugin.Analysable#scramble(Object, OperationQueue, int, int)
	 */
	// Eventuelles durcheinandernbringen einer Aufgabe
	public static OperationQueue scramble(Object o, OperationQueue givenOperations, int difficulty, int mode) {
		OperationQueue oq = new OperationQueue();
		if(givenOperations.length()==0) return oq;
		oq = (OperationQueue)givenOperations.clone();
		oq = analyzer.scramble(o, oq, difficulty, mode);
		//oq = FibHeapAnalyse.scramble((FibHeapOperations)o);
		/*
		// Ausgabe
		String s = "Scramble-Operations (#: "+oq.length()+"):\n\n";
		for(int i=0; i<oq.length(); i++) s += oq.get(i)+"\n";
		s += "\nOverall-Rating: "+oq.getRating();
		javax.swing.JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), s);
		*/
		return oq;
	}
	/**
	 * Generates the todo-operations
	 * @param o
	 * @param operationQueue
	 * @param difficulty
	 * @param mode
	 * @return OperationQueue
	 * @see mauda.plugin.Analysable#autoGen(Object, OperationQueue, int, int)
	 */
	// Die eigentliche Aufgabenstellung erstellen
	public static OperationQueue autoGen(Object o, OperationQueue operationQueue, int difficulty, int mode) {
		OperationQueue oq = new OperationQueue();
		if(operationQueue.length()==0) return oq;
		oq = (OperationQueue)operationQueue.clone();
		oq = analyzer.autoGen(o, oq, difficulty, mode);
		return oq;
	}
	/**
	 * Generates a complete exercise
	 * @param o
	 * @param initOQ
	 * @param scrambleOQ
	 * @param autoGenOQ
	 * @param difficulty
	 * @param mode
	 * @return init-operations[0] and todo-operations[1]
	 * @see mauda.plugin.Analysable#fullAutomatic(Object, OperationQueue, OperationQueue, OperationQueue, int, int)
	 */
	// Voll automatische Generierung einer Aufgabe
	public static OperationQueue[] fullAutomatic(Object o,
					OperationQueue initOQ,
					OperationQueue scrambleOQ,
					OperationQueue autoGenOQ,
					int difficulty,
					int mode) {
		OperationQueue ioq = (OperationQueue)initOQ.clone();
		OperationQueue soq = (OperationQueue)scrambleOQ.clone();
		OperationQueue aoq = (OperationQueue)autoGenOQ.clone();
		OperationQueue[] mainOQ = analyzer.fullAutomatic(o, ioq, soq, aoq, difficulty, mode);
		return mainOQ;						
	}
}