/*
 * Created on 08.01.2004 14:40:01
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin;

import mauda.MAUDA;
import mauda.operation.*;

import javax.swing.JOptionPane;

/**
 * Maps operation-ids to the corresponding methods in the
 * data-structure. Every PlugIn must have a class that extends
 * this class.
 * 
 * @author Markus Krebs
 */
public class OperationExecuter {
	
	protected Ratings ratings;
	
	/**
	 * Creates a OperationExecuter
	 */
	public OperationExecuter() {
		ratings = new Ratings();
	}
	
	/**
	 * Executes an Operation on a copy of the current
	 * data-structure, and filles consequently the SubOperations for
	 * the current operation, without changing the current
	 * data-structure. This method is needed to determine the
	 * correct suboperations for an Operation.
	 * 
	 * @param op Operation
	 * @param o data-structure
	 */
	// Operation auf Kopie(!) ausfhren, so dass SubOperationen
	// gefllt werden.
	// Wird bentigt, damit bei einem Template die SubOperationen
	// visualisiert werden knnen.
	// Wird auch fr WorkEditor bentigt (correctsubop...) 
	public void executeTemplate(Operation op, Object o) {
		
	}
	
	/**
	 * Executes an Operation on the current data-structure
	 * @param op Operation
	 * @param o data-structure
	 */
	public void execute(Operation op, Object o) {
		String msg =	"Perform:\n"+
						"Operation: "+op+"\n"+
						"On Object:"+o;
		JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), msg);
	}
	/**
	 * Executes an SubOperation on the current data-structure
	 * @param op SubOperation
	 * @param o data-structure
	 */
	public void execute(SubOperation op, Object o) {
		String msg =	"Perform:\n"+
						"SubOperation: "+op+"\n"+
						"On Object:"+o;
		JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), msg);
	}
	
	/**
	 * Gets the Ratings for the SubOperations.
	 * @return Ratings
	 */
	public Ratings getRatings() {
		return ratings;
	}
	/**
	 * Sets the Ratings for the SubOperations.
	 * @param r Ratings
	 */
	public void setRatings(Ratings r) {
		this.ratings = r;
	}
}
