/*
 * Created on 08.01.2004 14:23:30
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin;

import java.util.*;
/**
 * Stores suboperation-ratings needed for automatic generation
 * of exercises.
 * 
 * @author Markus Krebs
 */
public class Ratings extends HashMap {

	/**
	 * Creates a Ratings-Object
	 */
	public Ratings() {
		/*
		// SETKEY CUT MARK UNMARK NEWFHEAPMELD LINK UPDATEMIN REMOVE
		put("SETKEY", new Integer(1));
		put("CUT", new Integer(3));
		put("MARK", new Integer(4));
		put("UNMARK", new Integer(4));
		put("NEWFHEAPMELD", new Integer(2));
		put("LINK", new Integer(1));
		put("UPDATEMIN", new Integer(1));
		put("REMOVE", new Integer(1));
		*/
	}
	/**
	 * Converts the values of this class in a vector-representation
	 * for saving-purposes
	 * @return vector-representation of Ratings
	 */
	// Vorbereitung fr sptere Speicherung
	public Vector save() {
		Vector vector = new Vector();
		Iterator it = keySet().iterator();
		while(it.hasNext()) {
			String key = (String)it.next();
			int value = ((Integer)get(key)).intValue();
			vector.add(key+" "+value);
		}
		return vector;
	}
	/**
	 * Loads this Ratings-Object with the values of the vector-
	 * representation. This is needed for loading-purposes.
	 * @param vector vector-representation of Ratings
	 */
	// Vorbereitung frs Laden
	public void load(Vector vector) {
		clear();
		Enumeration en = vector.elements();
		while(en.hasMoreElements()) {
			String s = (String)en.nextElement();
			StringTokenizer st = new StringTokenizer(s);
			String key = st.nextToken();
			int value = Integer.parseInt(st.nextToken());
			put(key, new Integer(value));
		}
	}
}
