/*
 * Created on 07.01.2004 14:26:25
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin.binqueue;

//import mauda.MAUDA;
import mauda.plugin.*;
import mauda.operation.*;

import java.util.*;
/**
 * Maps operation-ids to the corresponding methods in the
 * FibHeap-data-structure.
 * 
 * @author Markus Krebs
 */
public class BinQueueOperationExecuter extends OperationExecuter {
	
	/**
	 * 
	 */
	public BinQueueOperationExecuter() {
		super();	// Muss aufgerufen werden
	}
	
	public void executeTemplate(Operation op, Object o) {
		if(!(o instanceof BinQueue)) return;
		//javax.swing.JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "executeTemplate");
		BinQueue fibHeapCopy = (BinQueue)((BinQueue)o).copyDS();
		execute(op, fibHeapCopy);
	}
	
	// OPERATION
	public void execute(Operation op, Object o) {
		if(!(o instanceof BinQueue)) return;
		BinQueue binqueue = (BinQueue)o;
		binqueue.clearSubOperationQueue();
		String operation = op.getID();
		int param1 = op.getParameter1();
		int param2 = op.getParameter2();
		if(operation.equals("INSERT")) binqueue.insertOp(param1);
		else if(operation.equals("DELETE")) binqueue.deleteOp(param1);
		else if(operation.equals("DECREASE_KEY")) binqueue.decreasekeyOp(param1,param2);
		else if(operation.equals("DELETE_MIN")) {
			int k = binqueue.deleteminOp();
			op.setEffect(k);
		} 
		// Rating anhand der SubOperation ausrechnen
		int rating = 0;
		SubOperationQueue soq = binqueue.getSubOperationQueue();
		Enumeration en = soq.toVector().elements();
		while(en.hasMoreElements()) {
			SubOperation so = (SubOperation)en.nextElement();
			rating += ((Integer)ratings.get(so.getID())).intValue();
		}
		op.setSubOperationQueue((SubOperationQueue)soq.clone());
		op.setRating(rating);
		//System.out.println(this);	// muss nach allem stehen da effect von delete-min
	}
	
	// SUBOPERATION
	public void execute(SubOperation op, Object o) {
		if(!(o instanceof BinQueue)) return;
		BinQueue binqueue = (BinQueue)o;
		//if(!(o instanceof FibHeapExt)) return;
		//FibHeapExt fibHeap = (FibHeapExt)o;
		binqueue.clearSubOperationQueue();
		String operation = op.getID();
		int param1 = op.getParameter1();
		int param2 = op.getParameter2();
		if(operation.equals("SETKEY")) binqueue.setKeyOp(param1,param2);
		else if(operation.equals("CUT")) binqueue.cutOp(param1);
		else if(operation.equals("MARK")) binqueue.markOp(param1);
		else if(operation.equals("UNMARK")) binqueue.unmarkOp(param1);
		else if(operation.equals("NEWFHEAPMELD")) binqueue.newFHeapMeldOp(param1);
		else if(operation.equals("LINK")) binqueue.linkOp(param1, param2);
		else if(operation.equals("UPDATEMIN")) binqueue.updateMinOp(param1);
		else if(operation.equals("REMOVE")) binqueue.removeOp(param1);
		//System.out.println(this);	// muss nach allem stehen da effect von delete-min
	}
}
