/*
 * Created on ?
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin.fibheap;

import java.awt.Color;
import jedas.*;

/**
 * @author Markus Krebs
 *
 * Code
 */
public class ArrayObj {
	protected CompObj compObj;
	
	private int length;
	private LineObj top, middle, bottom;
	private LineObj[] vertical;
	private TextObj[] number;
	private static double SIZE		= 0.045;
	private static double TEXTSIZE	= SIZE*0.75;
	private static double TextPosX	= SIZE*0.5;
	private static double TextPosY	= (SIZE+TEXTSIZE)*0.5;
	private static double CenterY	= SIZE*1.5;

	/**
	 * Constructs an array of the given length.
	 *
	 * @param length the number of elements in the array
	 */
	public ArrayObj(int length) {
		compObj = new CompObj();
		
		this.length = length;
		vertical = new LineObj[length+1];
		number = new TextObj[length];
		for (int i=0; i<length+1; i++) {
			if (i<length) {
				number[i] = new TextObj(i+"",
							new DPair(i*SIZE+TextPosX,TextPosY),
							TEXTSIZE);
				compObj.addItem(number[i]);
			}
			vertical[i] = new LineObj(new DPair(i*SIZE,0),
						  new DPair(i*SIZE,2*SIZE),
						  Color.black);
			compObj.addItem(vertical[i]);
		}
		top	= new LineObj(new DPair(0,0),
					new DPair(length*SIZE,0), Color.black);
		middle = new LineObj(new DPair(0,SIZE),
					new DPair(length*SIZE,SIZE), Color.black);
		bottom = new LineObj(new DPair(0,2*SIZE),
					new DPair(length*SIZE,2*SIZE), Color.black);
		compObj.addItem(top);
		compObj.addItem(middle);
		compObj.addItem(bottom);

		compObj.setPos(new DPair(0.5 * (1 - SIZE*length), SIZE*0.5));
	}

	/**
	 * Returns the position of the center of the specified square
	 * relative to the parent <tt>Composite</tt> of this array.
	 *
	 * @param label the label of the array entry
	 * @return the center position of that square
	 */
	public DPair getPosition(int label) {
		if (label<0 && label>=length) {
			return null;
		} else {
				return new DPair(compObj.getPos().get(0)+label*SIZE+TextPosX,
								compObj.getPos().get(1)+CenterY);
		}
	}
}
