/*
 * Created on 14.12.2003 18:33:31
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin.fibheap;

import mauda.operation.*;

/**
 * Interface for the suboperations on Fibonacci-Heaps.
 * 
 * @author Markus Krebs
 */
public interface FibHeapSubOperations {
	/**
	 * SETKEY
	 * @param node old-value
	 * @param key new-value
	 */
	public void setKeyOp(int node, int key);
	/**
	 * CUT
	 * @param node key of node to cut
	 */
	public void cutOp(int node);
	/**
	 * MARK
	 * @param node key of node to mark
	 */
	public void markOp(int node);
	/**
	 * UNMARK
	 * @param node key of node to unmark
	 */
	public void unmarkOp(int node);
	/**
	 * NEWFHEAPMELD
	 * @param node key of node to insert
	 */
	public void newFHeapMeldOp(int node);
	/**
	 * LINK
	 * @param node1 key of node
	 * @param node2 key of node that should linked to the first node
	 */
	public void linkOp(int node1, int node2);
	/**
	 * UPDATEMIN
	 * @param node key of new minimum
	 */
	public void updateMinOp(int node);
	/**
	 * REMOVE
	 * @param node key of node to remove
	 */
	public void removeOp(int node);
	
	/**
	 * Clears the SubOperationQueue of an Operation (e.g. INSERT)
	 */
	public void clearSubOperationQueue();
	/**
	 * Gets the SubOperationQueue of an Operation
	 * @return suboperations
	 */
	public SubOperationQueue getSubOperationQueue();
}
