/*
 * Created on ?
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.plugin.fibheap;

import mauda.utils.Prop;

import java.awt.*;
import java.awt.event.*;
/**
 * Interactive-PopUpMenu when exercise in
 * Interactive-OPERATION-Mode 
 * 
 * @author Markus Krebs
 */
class HeapOpMenu extends PopupMenu {
	protected static final String deleteMin = "DeleteMin";
	protected static final String deleteNode = "DeleteNode";
	protected static final String randomInsert = "RandomInsert";
	protected static final String randomDecreaseKeyNode = "RandomDecreaseKeyNode";
	protected static final String insert = "Insert";
	protected static final String decreaseKeyNode = "DecreaseKeyNode";

	private Menu     INSERT			= new Menu(Prop.get(this, "PopUp"+insert));
	private Menu     DECREASEKEY	= new Menu(Prop.get(this, "PopUp"+decreaseKeyNode));
	private Menu[] insMenu	= new Menu[4];
	private Menu[] decMenu	= new Menu[4];

	
	/**
	 * Creates a new HeapOpMenu
	 * @param onNode true if a menu should generated which will be displayed when the user is on a node, false otherwise
	 * @param al The listener for the menu
	 */	
	public HeapOpMenu(boolean onNode, ActionListener al) {
		super();
		INSERT.add(createMenuItem(randomInsert));
		INSERT.addSeparator();
		DECREASEKEY.add(createMenuItem(randomDecreaseKeyNode));
		DECREASEKEY.addSeparator();
		for (int j=0; j<4; j++) {
			if (j==0) {
				insMenu[j] = new Menu(" 1 .. 24 ");
				decMenu[j] = new Menu(" 1 .. 24 ");
			} else {
				insMenu[j] = new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
				decMenu[j] = new Menu((j*25) +" .. "+ ((j+1)*25-1) +" ");
			}
			INSERT.add(insMenu[j]);
			insMenu[j].addActionListener(al);
			DECREASEKEY.add(decMenu[j]);
			decMenu[j].addActionListener(al);
		}
		for (int i=1; i<100; i++) {
			insMenu[i/25].add(createNumberMenuItem(insert, i));
			decMenu[i/25].add(createNumberMenuItem(decreaseKeyNode, i));
		}
		this.addActionListener(al);
		this.DECREASEKEY.addActionListener(al);
		this.INSERT.addActionListener(al);
		// Menu aufbauen
		if (onNode) {
			add(DECREASEKEY);
			add(createMenuItem(deleteNode));
			addSeparator();
			add(INSERT);
			add(createMenuItem(deleteMin));
		} else {
			add(INSERT);
			add(createMenuItem(deleteMin));
		}
	}
	
	// COMMON
	private MenuItem createMenuItem(String s) {
		MenuItem mi = new MenuItem(Prop.get(this, "PopUp"+s));
		mi.setActionCommand(s);
		return mi;
	}
	private MenuItem createNumberMenuItem(String command, int nr) {
		String s = Integer.toString(nr);
		MenuItem mi = new MenuItem(s);
		mi.setActionCommand(command+" "+s);
		return mi;
	}
}