/*
 * Created on 26.10.2004 14:06:38
 *
 * Multimediale Algorithmen und Datenstrukturen Assessmentss
 */
package mauda.undoredo;

/**
 * Stores one single elementary undo/redo element
 * 
 * @author Markus Krebs
 */
public class UndoRedoElement {
	
	/**
	 * ID for defining a undefined element, only for initialisation used. An UndoRedoElement
	 * with this state cannot processed!
	 */
	public static final int UNDEFINED = -1;
	/**
	 * ID that indicates that an operation was deleted
	 */
	public static final int DELETE = 0;
	/**
	 * ID that indicates that an operation was appended
	 */
	public static final int APPEND = 1;

	private int pos;
	private Object obj;
	private int id;
	
	/**
	 * Creates an UndoRedoElement
	 */
	public UndoRedoElement() {
		pos = -1;
		obj = null;
		id = UNDEFINED;
	}
	/**
	 * Creates an UndoRedoElement
	 * @param p The position where the change occures
	 * @param o The corresponding object (operation, fibheap, etc.)
	 * @param i ID
	 */
	public UndoRedoElement(int p, Object o, int i) {
		pos = p;
		obj = o;
		id = i;
	}
	/**
	 * Returns the position where the change occured
	 * @return position
	 */
	public int getPos() { return pos; }
	/**
	 * Returns the corresponding object
	 * @return object
	 */
	public Object getObj() { return obj; }
	/**
	 * Returns the ID of the change
	 * @return ID
	 */
	public int getID() { return id; }
	
	/**
	 * Inverts this element. This means that an DELETE is changed to APPEND and vice versa.
	 * Used to undo an action.
	 * @return inverted element
	 */
	public UndoRedoElement invert() {
		int newid = DELETE;
		if(id==DELETE) newid = APPEND;
		return new UndoRedoElement(pos,obj,newid);
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String s = "URElement:  '"+pos+"'  '"+obj+"'  '";
		switch(id) {
			case UNDEFINED : s+="UNDEFINED"; break;
			case DELETE : s+="DELETE"; break;
			case APPEND : s+="APPEND"; break;
		}
		s+="'";
		return s;
	}
}
