/*
 * Created on 18.03.2004 14:23:02
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import java.io.File;
/**
 * Stores the directory and file-settings where to save exercises
 * and additional data
 * 
 * @author Markus Krebs
 */
public class FileLocation {

	/**
	 * Directory where to store generated but not processed
	 * exercises
	 */
	public static String unworkedPath;
	/**
	 * Directory where to store exercises that are <i>in process</i>
	 */
	public static String inProcessPath;
	/**
	 * Directory where to store completely evaluated exercises.
	 */
	public static String evaluatedPath;
	/**
	 * Directory where to store totally processed but not evaluated
	 * exercises.
	 */
	public static String completedPath;
	
	/**
	 * Specifies the filename (with path) for temporary saving of
	 * a recorded jedas-animation.
	 */
	// Dateiname fr Aufnahmen-Speicherung
	public static String jedasRecordingFilename;
	
	/**
	 * The prefix of the filename for storing new generated
	 * exercises. A number will be added.
	 */
	// Dateiname fr Speicherung der generierten Aufgaben
	// Eine Zahl wird angehngt
	public static String unworkedPrefix = "ex_";
	/**
	 * The prefix of the filename for storing automatically
	 * evaluated exercises. A number will be added.
	 */
	// Dateiname fr Speicherung der evaluierten Aufgaben
	public static String evaluatedPrefix = "eval_";
	/**
	 * The prefix of the filename for storing completely processed
	 * but not evaluated exercises.
	 */
	// Dateiname fr Speicherung der fertigen noch nicht
	// evaluierten Aufgaben
	public static String completedPrefix = "comp_";

	// nrSize-stellige Zahl erzeugen (Anfang mit Nullen fllen)
	private static final int nrSize = 5;
	
	/**
	 * Creates a FileLocation
	 */
	public FileLocation() {
	}
	/**
	 * Fills the static variables (path-variables)
	 */
	public static void config() {
		File exFiles = new File("exercises/unworked");
		File inProcessFiles = new File("exercises/in_process");
		File evaluatedFiles = new File("exercises/evaluated");
		File completedFiles = new File("exercises/completed");
		
		unworkedPath = exFiles.getAbsolutePath();
		inProcessPath = inProcessFiles.getAbsolutePath();
		evaluatedPath = evaluatedFiles.getAbsolutePath();
		completedPath = completedFiles.getAbsolutePath();
		
		File file = new File(evaluatedPath, "recording.jea");
		jedasRecordingFilename = file.getAbsolutePath();

		/*
		System.out.println("unworkedPath  = "+unworkedPath);
		System.out.println("inProcessPath = "+inProcessPath);
		System.out.println("evaluatedPath = "+evaluatedPath);
		System.out.println("completedPath = "+completedPath);
		
		System.out.println("jedasRecordingFilename = "+jedasRecordingFilename);
		*/
	}
	private static String getNumber(int nr) {
		String s = nr+"";
		while(s.length()<nrSize) s="0"+s;
		return s;
	}
	/**
	 * Generates automatically a filename, which currently not
	 * exists.
	 * @param path The destination folder
	 * @param savePrefix The prefix for the new filename
	 * @return A non-existing filename in the destination folder, which starts with the given prefix
	 */
	public static String genFilename(String path, String savePrefix) {
		String filename = "";
		File file = null;
		int counter = 0;
		do {
			filename = savePrefix+getNumber(counter)+".xml"; 
			//System.out.println("FILENAME: "+filename);
			file = new File(path, filename);
			filename = file.getAbsolutePath();
			counter++;
		//} while(counter<100000);
		} while(file.exists());
		//System.out.println("FILENAME: "+filename);
		return filename;
	}

}
