/*
 * Created on 18.02.2004 21:17:31
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.html.*;
import java.awt.*;
import java.io.*;
/**
 * Generates a HTML-View
 * 
 * @author Markus Krebs
 */
public class HTMLView {
	
	/**
	 * The HTML-Editor-Kit which is used for the View.
	 */
	public static HTMLEditorKit htmlEditorKit = new HTMLEditorKit();
	
	private JPanel panel;
	private JEditorPane editorPane;
	
	/**
	 * Creates a HTMLView
	 * @param hl The HyplerlinkListener for the view.
	 */
	public HTMLView(HyperlinkListener hl) {
		panel = new JPanel();
		panel.setLayout(new BorderLayout());
		editorPane = new JEditorPane();
		editorPane.setEditable(false);
		editorPane.setEditorKit(htmlEditorKit);
		JScrollPane sp = new JScrollPane(editorPane);
		//sp.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		panel.add(sp, BorderLayout.CENTER);
		try{
			File f = new File(".");
			((HTMLDocument)editorPane.getDocument()).setBase(f.toURL());
		} catch(java.net.MalformedURLException ex) {
			ex.printStackTrace();
		}
		/*
		displayMessage(
			"<table border=0 cellpadding=1><tr>"+
				"<td valign=top><img src='./images/correct_v.gif'></td>"+
				"<td><b>Correct</b></td>"+
			"</tr><tr>"+
				"<td valign=top><img src='./images/lamp.gif'></td>"+
				"<td>Descriptrion of the failure. Might be a very long text. But thats no problem because of the use of html. The text will be wrapped without problems.</td>"+
			"</tr><td></td><td align=right>"+
				"<a href='more'>more...</a><br>"+
				"</td>"+
			"</tr></table>"+
			"<a href='testlink'>test-link</a><br>");
		*/
		//displayMessage("<img src='./images/general/undo24.gif'>TEST");
		editorPane.addHyperlinkListener(hl);
		//editorPane.setDoubleBuffered(true);
		//editorPane.setPreferredSize(new Dimension(220,100));
		setBodyHTML("EMPTY");
	}
	/**
	 * Gets the panel
	 * @return panel
	 */
	public JPanel getPanel() {
		return panel;
	}
	/**
	 * Sets the HTML-Text of the view.<br>
	 * Important: The delivered String must be a complete HTML-
	 * Document. (Compare with setBodyHTML)
	 * @param html html-text
	 * @see mauda.utils.HTMLView#setBodyHTML(String)
	 */
	public void setHTML(String html) {
		editorPane.setText(html);
		editorPane.setCaretPosition(0);
	}
	/**
	 * Sets the HTML-Text of the view.<br>
	 * Important: The delivered string should only contain the
	 * html-code between the body-tags.
	 * @param html html-text
	 * @see mauda.utils.HTMLView#setHTML(String)
	 */
	public void setBodyHTML(String html) {
		editorPane.setText(
			"<HTML><TITLE>No Title</TITLE><BODY>"+
			html+
			"</BODY></HTML>");
		editorPane.setCaretPosition(0);
	}

}
