/*
 * Created on 25.02.2004 13:44:09
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import mauda.*;

import java.awt.event.*;
import javax.swing.*;

/**
 * Handles the window-closing-event, to guarantee, that no changings
 * on exercises are lost.
 * 
 * @author Markus Krebs
 */
public class MyWindowListener extends WindowAdapter {

	private Exercise exercise;
	/**
	 * Creates a window-listener
	 * @param exercise Exercise
	 */
	public MyWindowListener(Exercise exercise) {
		super();
		this.exercise = exercise;
	}
	/* (non-Javadoc)
	 * @see java.awt.event.WindowListener#windowClosing(java.awt.event.WindowEvent)
	 */
	public void windowClosing(WindowEvent e) {
		//System.out.println("windowClosing");
		if(exercise.isModified() && !dialogExit()) return;
		System.exit(0);
	}
	// Aktive Aufgabe verwerfen? - Dialog
	private boolean dialogExit() {
		if(!exercise.isModified()) return true;
		String s = Prop.get(this, "WindowClosingDialog");
		int result = JOptionPane.showConfirmDialog(MAUDA.getApplicationMainFrame(), s, Prop.get(this, "WindowClosingDialogTitle"), JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
		if(result == JOptionPane.YES_OPTION) { return true; }
		//else if(result == JOptionPane.NO_OPTION) { return false; }
		//else if(result == JOptionPane.CANCEL_OPTION) { return false; }
		return false;		
	}

}
