/*
 * Created on 15.01.2004 17:58:44
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import mauda.*;

import java.io.*;
import javax.swing.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Previewpanel for filechooser.
 * 
 * @author Markus Krebs
 */
public class PreviewPanel extends JPanel implements ActionListener {
	private JTextArea textArea;
	private JButton showMeta;
	private MetaData metaData;
	/**
	 * Creates a preview-panel
	 */
	public PreviewPanel() {
		setLayout(new BorderLayout());
		metaData = null;
		JLabel label = new JLabel(" Meta-Data");
		label.setBorder(BorderFactory.createEtchedBorder()); 
		add(label, BorderLayout.NORTH);
		textArea = new JTextArea("", 7, 13);
		textArea.setEditable(false);
		textArea.setLineWrap(true);
		add(new JScrollPane(textArea), BorderLayout.CENTER);
		showMeta = new JButton("Show");
		showMeta.setMargin(new Insets(0,0,0,0));
		showMeta.setEnabled(false);
		showMeta.addActionListener(this); 
		add(showMeta, BorderLayout.SOUTH);
	}
	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if(metaData == null) return;
		boolean mod = metaData.inputDialog();
		if(mod) JOptionPane.showMessageDialog(MAUDA.getApplicationMainFrame(), "Changings in Meta-Data will not be saved!");
	}
	
	/**
	 * Configures/Fills the preview with meta-data of the given
	 * file.
	 * @param f File
	 */
	public void configure(File f) {
		String msg = "";
		if(f.exists()) {
			String filename = f.getAbsolutePath();
			Vector v = XMLFileAccess.load(filename);
			if(v==null) {
				textArea.setText("");
				showMeta.setEnabled(false);	
				metaData = null; 
				return;
			} 
			HashMap ht = (HashMap)v.firstElement();
		
			// Meta-Daten
			//meta = (HashMap)ht.get("Meta-Data");
			metaData = new MetaData();
			metaData.load(ht.get("Meta-Data"));
			showMeta.setEnabled(true);
			HashMap meta = metaData.save();
			msg = metaData.getPreviewString();
		} else {
			// Das Datei nicht exisitiert kann vorkommen wenn ein
			// neuer Dateiname im FileChooser eingegeben wird.
			// Seltsamerweise wird diese Methode nach dem Return-
			// oder Button-Drcken nochmal ausgefhrt.
			msg = "File not exists!";
		}
		textArea.setText(msg);
		textArea.setCaretPosition(0);	
	}
}
