/*
 * Created on ??.??.???? ??:??:??
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import java.io.File;
/**
 * Super-class for file-filters used in filechooser.
 *
 * @author Markus KREBS
 */
public abstract class SuffixAwareFilter extends javax.swing.filechooser.FileFilter {
	/**
	 * Returns the suffix of the given file.
	 * @param f File
	 * @return Suffix of the file
	 */
	public String getSuffix(File f) {
		String s = f.getPath(), suffix = null;
		int i = s.lastIndexOf('.');

		if(i > 0 && i < s.length() -1)
			suffix = s.substring(i+1).toLowerCase();

		return suffix;
	}
	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
	 */
	public boolean accept(File f) {
		return f.isDirectory();
	}
}
