/*
 * Created on 10.12.2003 15:58:38
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package mauda.utils;

import java.io.File;

/**
 * Filter for xml-files used in filechooser.
 * 
 * @author Markus Krebs
 */
public class XMLFilter extends SuffixAwareFilter {
	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
	 */
	public boolean accept(File f) {
		boolean accept = super.accept(f);

		if(!accept) {
			String suffix = getSuffix(f);

			if(suffix != null)
				accept = super.accept(f) || suffix.equals("xml");
		}
		return accept;
	}
	/* (non-Javadoc)
	 * @see javax.swing.filechooser.FileFilter#getDescription()
	 */
	public String getDescription() {
		return "XML-Files (*.xml)";
	}
}
