/*
 * Created on 19.01.2004 13:50:58
 *
 * Multimediale Algorithmen und Datenstrukturen Assessments
 */
package work;

import mauda.*;
import mauda.feedback.*;
import mauda.utils.MyWindowListener;
import mauda.utils.FileLocation;

import javax.swing.*;
import java.awt.*;

/**
 * The main-frame for the Working-Editor<br><br>
 * The Working-Editor is a program to process exercises, generated
 * by Generation-Editor or AutoGenerator, by a student.
 * 
 * @author Markus Krebs
 */
public class WorkEditor extends JFrame implements ExerciseUpdateListener {
	
	private String frameTitle = "MA&DA WorkEditor V1.01";

	/**
	 * Starts the Work-Editor
	 * @param args
	 */
	public static void main(String args[]) {
		//Prop.load("eng");	// Properties laden
		new WorkEditor();
	}
	
	/**
	 * Creates the Work-Editor
	 */
	public WorkEditor() {
		
		MAUDA.setApplicationMainFrame(this);
		
		// ReloadKB-Button-Anzeige?
		ActionCommands.showReloadKBButton = false;
		
		FileLocation.config();
		
		//setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);

		// WorkEditor mit FibHeap-PlugIn starten
		// wird spter beim Laden von anderen Aufgaben sowieso
		// angepasst
		FeedbackExercise exercise = new FeedbackExercise("FibHeap");
		exercise.addExerciseUpdateListener(this);
		exercise.setInteractiveMode(Exercise.NOPOPUP);

		// ModifiedDetector anmelden
		exercise.addExerciseUpdateListener(new ModifiedDetector(exercise));

		// WindowListener
		// fr ev. ungespeicherte nderungen
		addWindowListener(new MyWindowListener(exercise));
				
		// Grafisches / Layout
		Container contentPane = getContentPane();

		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		
		// Feedback (wird fr feedback.getPanel() bentigt -> siehe unten)
		SimpleFeedback.feedbackGenerator = new FeedbackGenerator(exercise);
		SimpleFeedback feedback = new mauda.feedback.types.NoTutor(exercise);
		exercise.setFeedback(feedback);
		
		MenuToolBarListener menuToolBarListener = new MenuToolBarListener(exercise);
		mainPanel.add(new TopToolBar(menuToolBarListener), BorderLayout.NORTH);
			
		// MenuBar
		setMenuBar(new WorkMenu(menuToolBarListener));

		// OP-PANEL und JEDAS-PANEL zusammenbringen
		JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setRightComponent(exercise.getFeedbackPanel());
		splitPane.setLeftComponent(exercise.jedasPanel);
		splitPane.setOneTouchExpandable(true);
		//splitPane.setDividerLocation(0.7);
		// Notwendig, damit verschieben nach links funktioniert
		exercise.getFeedbackPanel().setMinimumSize(new Dimension(240,50));
		exercise.jedasPanel.setMinimumSize(new Dimension(280, 50));

		mainPanel.add(splitPane, BorderLayout.CENTER);

		contentPane.add(mainPanel, BorderLayout.CENTER);
		
		exercise.jedasPanel.setMessage("Please load an exercise...");
		
		//setBounds(0, 160, 800, 500);	// <- wie bei GenEditor
		setBounds(0, 0, 800, 550);
		setTitle(frameTitle);
		setVisible(true);
		splitPane.setDividerLocation(540);	// 800-240 (-20)
		
		MetaData.setDisplayMode(MetaData.EDITOR);

		// FaultMode-Exercise
		//openFile(exercise, new File("exercises/faultmode_fault-link.xml"));
		// NormalMode-Exercise
		//Vector todo = openFile(exercise, new File("exercises/normalmode_short.xml"));
		
		/*
		Vector todo = openFile(exercise, new File("exercises/ex_00004.xml"));
		
		if(todo!=null) {
			((ImmediateFeedbackAndErrorCorrection)feedback).setTodoOperations(todo);
		}*/

	}
	
	/* (non-Javadoc)
	 * @see mauda.ExerciseUpdateListener#exerciseUpdate(mauda.ExerciseUpdateEvent)
	 */
	public void exerciseUpdate(ExerciseUpdateEvent e) {
		if(e.getID() != ExerciseUpdateEvent.FILENAME_CHANGED) return;
		// Nur Dateiname anzeigen (ohne Pfad)
		String filename = e.getExercise().getFilename();
		filename = filename.replace('\\', '/');
		filename = filename.substring(filename.lastIndexOf("/")+1);
		setTitle(filename + " - " + frameTitle);
	}
	

}