//	Priss (NekoAmp 2.0) - MPEG-1/2 audio decoding library
//	Copyright (C) 2003 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <vd2/system/vdtypes.h>
#include <windows.h>
#include "engine.h"
#include "bitreader.h"

namespace {
	const struct HuffQuad {
		sint8 x, y;
		uint8 bits;
		uint8 _pad;
	} hufftbl_1_fast[32]={	// maximum: 5 bits
		/* 00000 */ { +1, +1, 5 },
		/* 00001 */ { +1, -1, 5 },
		/* 00010 */ { -1, +1, 5 },
		/* 00011 */ { -1, -1, 5 },
		/* 0010x */ {  0, +1, 4 },	{ 0, +1, 4 },
		/* 0011x */ {  0, -1, 4 },	{ 0, -1, 4 },
		/* 010xx */ { +1,  0, 3 },	{ +1,  0, 3 },	{ +1,  0, 3 },	{ +1,  0, 3 },
		/* 011xx */ { -1,  0, 3 },	{ -1,  0, 3 },	{ -1,  0, 3 },	{ -1,  0, 3 },
		/* 1xxxx */ {  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
					{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
					{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
					{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
	}, hufftbl_2_lo[28]={
		/* 00100 */	{ +1, +1, 5 },
		/* 00101 */	{ +1, -1, 5 },
		/* 00110 */	{ -1, +1, 5 },
		/* 00111 */	{ -1, -1, 5 },
		/* 0100x */ {  0, +1, 4 },	{  0, +1, 4 },
		/* 0101x */ {  0, -1, 4 },	{  0, -1, 4 },
		/* 0110x */ { +1,  0, 4 },	{ +1,  0, 4 },
		/* 0111x */ { -1,  0, 4 },	{ -1,  0, 4 },
		/* 1xxxx */	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
					{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
					{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
					{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
	}, hufftbl_2_3_hi[32]={
		/* 00000000 */ { +2, +2, 8 },
		/* 00000001 */ { +2, -2, 8 },
		/* 00000010 */ { -2, +2, 8 },
		/* 00000011 */ { -2, -2, 8 },
		/* 0000010x */ {  0, +2, 7 }, {  0, +2, 7 },
		/* 0000011x */ {  0, -2, 7 }, {  0, -2, 7 },
		/* 0000100x */ { +1, +2, 7 }, { +1, +2, 7 },
		/* 0000101x */ { +1, -2, 7 }, { +1, -2, 7 },
		/* 0000110x */ { -1, +2, 7 }, { -1, +2, 7 },
		/* 0000111x */ { -1, -2, 7 }, { -1, -2, 7 },
		/* 0001000x */ { +2, +1, 7 }, { +2, +1, 7 },
		/* 0001001x */ { +2, -1, 7 }, { +2, -1, 7 },
		/* 0001010x */ { -2, +1, 7 }, { -2, +1, 7 },
		/* 0001011x */ { -2, -1, 7 }, { -2, -1, 7 },
		/* 000110xx */ { +2,  0, 6 }, { +2,  0, 6 }, { +2,  0, 6 }, { +2,  0, 6 },
		/* 000111xx */ { -2,  0, 6 }, { -2,  0, 6 }, { -2,  0, 6 }, { -2,  0, 6 },
	}, hufftbl_3_lo[14]={
		/* 0010 */	{ +1,  0, 4 },
		/* 0011 */	{ -1,  0, 4 },
		/* 0100 */	{ +1, +1, 4 },
		/* 0101 */	{ +1, -1, 4 },
		/* 0110 */	{ -1, +1, 4 },
		/* 0111 */	{ -1, -1, 4 },
		/* 100x */	{  0, +1, 3 }, {  0, +1, 3 },
		/* 101x */	{  0, -1, 3 }, {  0, -1, 3 },
		/* 11xx */	{  0,  0, 2 }, {  0,  0, 2 },
					{  0,  0, 2 }, {  0,  0, 2 },
	}, hufftbl_5_hi[28]={
		/* 001xx */	{ +1, +1, 5 }, { +1, -1, 5 }, { -1, +1, 5 }, { -1, -1, 5 },
		/* 010xx */	{  0, +1, 4 }, {  0, +1, 4 }, {  0, -1, 4 }, {  0, -1, 4 },
		/* 011xx */ { +1,  0, 4 }, { +1,  0, 4 }, { -1,  0, 4 }, { -1,  0, 4 },
		/* 1xxxx */ {  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 },
					{  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 },
					{  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 },
					{  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 }, {  0,  0, 1 },
	}, hufftbl_6_hi[54]={
		/* 00101x */	{  0, +2, 6 }, {  0, -2, 6 },
		/* 0011xx */	{ +1, +2, 6 }, { +1, -2, 6 }, { -1, +2, 6 }, { -1, -2, 6 },
		/* 0100xx */	{ +2, +1, 6 }, { +2, -1, 6 }, { -2, +1, 6 }, { -2, -1, 6 },
		/* 0101xx */	{ +2,  0, 5 }, { +2,  0, 5 }, { -2,  0, 5 }, { -2,  0, 5 },
		/* 011xxx */	{  0, +1, 4 }, {  0, +1, 4 }, {  0, +1, 4 }, {  0, +1, 4 },
						{  0, -1, 4 }, {  0, -1, 4 }, {  0, -1, 4 }, {  0, -1, 4 },
		/* 10xxxx */	{ +1, +1, 4 }, { +1, +1, 4 }, { +1, +1, 4 }, { +1, +1, 4 },
						{ +1, -1, 4 }, { +1, -1, 4 }, { +1, -1, 4 }, { +1, -1, 4 },
						{ -1, +1, 4 }, { -1, +1, 4 }, { -1, +1, 4 }, { -1, +1, 4 },
						{ -1, -1, 4 }, { -1, -1, 4 }, { -1, -1, 4 }, { -1, -1, 4 },
		/* 110xxx */	{ +1,  0, 4 }, { +1,  0, 4 }, { +1,  0, 4 }, { +1,  0, 4 },
						{ -1,  0, 4 }, { -1,  0, 4 }, { -1,  0, 4 }, { -1,  0, 4 },
		/* 111xxx */	{  0,  0, 3 }, {  0,  0, 3 }, {  0,  0, 3 }, {  0,  0, 3 },
						{  0,  0, 3 }, {  0,  0, 3 }, {  0,  0, 3 }, {  0,  0, 3 },
	};

	// These are trees from the reference code -- each node either holds
	// relative positive offsets for the next bit '0' or '1', or the
	// left branch is 0 and the right branch holds (x<<4)+y.

	static const uint8 table1[][2]={
	0x02,0x01,0x00,0x00,0x02,0x01,0x00,0x10,0x02,0x01,0x00,0x01,0x00,0x11 
	};

	static const uint8 table2[][2]={
	0x02,0x01,0x00,0x00,0x04,0x01,0x02,0x01,0x00,0x10,0x00,0x01,0x02,0x01,0x00,0x11,0x04,0x01,0x02,0x01,0x00,0x20,0x00,0x21, 
	0x02,0x01,0x00,0x12,0x02,0x01,0x00,0x02,0x00,0x22,
	};

	static const uint8 table3[][2]={
	0x04,0x01,0x02,0x01,0x00,0x00,0x00,0x01,0x02,0x01,0x00,0x11,0x02,0x01,0x00,0x10,0x04,0x01,0x02,0x01,0x00,0x20,0x00,0x21, 
	0x02,0x01,0x00,0x12,0x02,0x01,0x00,0x02,0x00,0x22, 
	};

	static const uint8 table5[][2]={
	0x02,0x01,0x00,0x00,0x04,0x01,0x02,0x01,0x00,0x10,0x00,0x01,0x02,0x01,0x00,0x11,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x20, 
	0x00,0x02,0x02,0x01,0x00,0x21,0x00,0x12,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x22,0x00,0x30,0x02,0x01,0x00,0x03,0x00,0x13, 
	0x02,0x01,0x00,0x31,0x02,0x01,0x00,0x32,0x02,0x01,0x00,0x23,0x00,0x33, 
	};

	static const uint8 table6[][2]={
	0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x00,0x00,0x10,0x00,0x11,0x06,0x01,0x02,0x01,0x00,0x01,0x02,0x01,0x00,0x20,0x00,0x21, 
	0x06,0x01,0x02,0x01,0x00,0x12,0x02,0x01,0x00,0x02,0x00,0x22,0x04,0x01,0x02,0x01,0x00,0x31,0x00,0x13,0x04,0x01,0x02,0x01, 
	0x00,0x30,0x00,0x32,0x02,0x01,0x00,0x23,0x02,0x01,0x00,0x03,0x00,0x33, 
	};

	static const uint8 table7[][2]={
	0x02,0x01,0x00,0x00,0x04,0x01,0x02,0x01,0x00,0x10,0x00,0x01,0x08,0x01,0x02,0x01,0x00,0x11,0x04,0x01,0x02,0x01,0x00,0x20, 
	0x00,0x02,0x00,0x21,0x12,0x01,0x06,0x01,0x02,0x01,0x00,0x12,0x02,0x01,0x00,0x22,0x00,0x30,0x04,0x01,0x02,0x01,0x00,0x31, 
	0x00,0x13,0x04,0x01,0x02,0x01,0x00,0x03,0x00,0x32,0x02,0x01,0x00,0x23,0x00,0x04,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x40, 
	0x00,0x41,0x02,0x01,0x00,0x14,0x02,0x01,0x00,0x42,0x00,0x24,0x0c,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x33,0x00,0x43, 
	0x00,0x50,0x04,0x01,0x02,0x01,0x00,0x34,0x00,0x05,0x00,0x51,0x06,0x01,0x02,0x01,0x00,0x15,0x02,0x01,0x00,0x52,0x00,0x25, 
	0x04,0x01,0x02,0x01,0x00,0x44,0x00,0x35,0x04,0x01,0x02,0x01,0x00,0x53,0x00,0x54,0x02,0x01,0x00,0x45,0x00,0x55, 
	};

	static const uint8 table8[][2]={
	0x06,0x01,0x02,0x01,0x00,0x00,0x02,0x01,0x00,0x10,0x00,0x01,0x02,0x01,0x00,0x11,0x04,0x01,0x02,0x01,0x00,0x21,0x00,0x12, 
	0x0e,0x01,0x04,0x01,0x02,0x01,0x00,0x20,0x00,0x02,0x02,0x01,0x00,0x22,0x04,0x01,0x02,0x01,0x00,0x30,0x00,0x03,0x02,0x01, 
	0x00,0x31,0x00,0x13,0x0e,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x32,0x00,0x23,0x02,0x01,0x00,0x40,0x00,0x04,0x02,0x01, 
	0x00,0x41,0x02,0x01,0x00,0x14,0x00,0x42,0x0c,0x01,0x06,0x01,0x02,0x01,0x00,0x24,0x02,0x01,0x00,0x33,0x00,0x50,0x04,0x01, 
	0x02,0x01,0x00,0x43,0x00,0x34,0x00,0x51,0x06,0x01,0x02,0x01,0x00,0x15,0x02,0x01,0x00,0x05,0x00,0x52,0x06,0x01,0x02,0x01, 
	0x00,0x25,0x02,0x01,0x00,0x44,0x00,0x35,0x02,0x01,0x00,0x53,0x02,0x01,0x00,0x45,0x02,0x01,0x00,0x54,0x00,0x55, 
	};

	static const uint8 table9[][2]={
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x00,0x00,0x10,0x02,0x01,0x00,0x01,0x00,0x11,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x20, 
	0x00,0x21,0x02,0x01,0x00,0x12,0x02,0x01,0x00,0x02,0x00,0x22,0x0c,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x30,0x00,0x03, 
	0x00,0x31,0x02,0x01,0x00,0x13,0x02,0x01,0x00,0x32,0x00,0x23,0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0x41,0x00,0x14,0x04,0x01, 
	0x02,0x01,0x00,0x40,0x00,0x33,0x02,0x01,0x00,0x42,0x00,0x24,0x0a,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x04,0x00,0x50, 
	0x00,0x43,0x02,0x01,0x00,0x34,0x00,0x51,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x15,0x00,0x52,0x02,0x01,0x00,0x25,0x00,0x44, 
	0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x05,0x00,0x54,0x00,0x53,0x02,0x01,0x00,0x35,0x02,0x01,0x00,0x45,0x00,0x55, 
	};

	static const uint8 table10[][2]={
	0x02,0x01,0x00,0x00,0x04,0x01,0x02,0x01,0x00,0x10,0x00,0x01,0x0a,0x01,0x02,0x01,0x00,0x11,0x04,0x01,0x02,0x01,0x00,0x20, 
	0x00,0x02,0x02,0x01,0x00,0x21,0x00,0x12,0x1c,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x22,0x00,0x30,0x02,0x01,0x00,0x31, 
	0x00,0x13,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x03,0x00,0x32,0x02,0x01,0x00,0x23,0x00,0x40,0x04,0x01,0x02,0x01,0x00,0x41, 
	0x00,0x14,0x04,0x01,0x02,0x01,0x00,0x04,0x00,0x33,0x02,0x01,0x00,0x42,0x00,0x24,0x1c,0x01,0x0a,0x01,0x06,0x01,0x04,0x01, 
	0x02,0x01,0x00,0x50,0x00,0x05,0x00,0x60,0x02,0x01,0x00,0x61,0x00,0x16,0x0c,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x43, 
	0x00,0x34,0x00,0x51,0x02,0x01,0x00,0x15,0x02,0x01,0x00,0x52,0x00,0x25,0x04,0x01,0x02,0x01,0x00,0x26,0x00,0x36,0x00,0x71, 
	0x14,0x01,0x08,0x01,0x02,0x01,0x00,0x17,0x04,0x01,0x02,0x01,0x00,0x44,0x00,0x53,0x00,0x06,0x06,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x35,0x00,0x45,0x00,0x62,0x02,0x01,0x00,0x70,0x02,0x01,0x00,0x07,0x00,0x64,0x0e,0x01,0x04,0x01,0x02,0x01,0x00,0x72, 
	0x00,0x27,0x06,0x01,0x02,0x01,0x00,0x63,0x02,0x01,0x00,0x54,0x00,0x55,0x02,0x01,0x00,0x46,0x00,0x73,0x08,0x01,0x04,0x01, 
	0x02,0x01,0x00,0x37,0x00,0x65,0x02,0x01,0x00,0x56,0x00,0x74,0x06,0x01,0x02,0x01,0x00,0x47,0x02,0x01,0x00,0x66,0x00,0x75, 
	0x04,0x01,0x02,0x01,0x00,0x57,0x00,0x76,0x02,0x01,0x00,0x67,0x00,0x77, 
	};

	static const uint8 table11[][2]={
	0x06,0x01,0x02,0x01,0x00,0x00,0x02,0x01,0x00,0x10,0x00,0x01,0x08,0x01,0x02,0x01,0x00,0x11,0x04,0x01,0x02,0x01,0x00,0x20, 
	0x00,0x02,0x00,0x12,0x18,0x01,0x08,0x01,0x02,0x01,0x00,0x21,0x02,0x01,0x00,0x22,0x02,0x01,0x00,0x30,0x00,0x03,0x04,0x01, 
	0x02,0x01,0x00,0x31,0x00,0x13,0x04,0x01,0x02,0x01,0x00,0x32,0x00,0x23,0x04,0x01,0x02,0x01,0x00,0x40,0x00,0x04,0x02,0x01, 
	0x00,0x41,0x00,0x14,0x1e,0x01,0x10,0x01,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x42,0x00,0x24,0x04,0x01,0x02,0x01,0x00,0x33, 
	0x00,0x43,0x00,0x50,0x04,0x01,0x02,0x01,0x00,0x34,0x00,0x51,0x00,0x61,0x06,0x01,0x02,0x01,0x00,0x16,0x02,0x01,0x00,0x06, 
	0x00,0x26,0x02,0x01,0x00,0x62,0x02,0x01,0x00,0x15,0x02,0x01,0x00,0x05,0x00,0x52,0x10,0x01,0x0a,0x01,0x06,0x01,0x04,0x01, 
	0x02,0x01,0x00,0x25,0x00,0x44,0x00,0x60,0x02,0x01,0x00,0x63,0x00,0x36,0x04,0x01,0x02,0x01,0x00,0x70,0x00,0x17,0x00,0x71, 
	0x10,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x07,0x00,0x64,0x00,0x72,0x02,0x01,0x00,0x27,0x04,0x01,0x02,0x01,0x00,0x53, 
	0x00,0x35,0x02,0x01,0x00,0x54,0x00,0x45,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x46,0x00,0x73,0x02,0x01,0x00,0x37,0x02,0x01, 
	0x00,0x65,0x00,0x56,0x0a,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x55,0x00,0x57,0x00,0x74,0x02,0x01,0x00,0x47,0x00,0x66, 
	0x04,0x01,0x02,0x01,0x00,0x75,0x00,0x76,0x02,0x01,0x00,0x67,0x00,0x77, 
	};

	static const uint8 table12[][2]={
	0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0x10,0x00,0x01,0x02,0x01,0x00,0x11,0x02,0x01,0x00,0x00,0x02,0x01,0x00,0x20,0x00,0x02, 
	0x10,0x01,0x04,0x01,0x02,0x01,0x00,0x21,0x00,0x12,0x04,0x01,0x02,0x01,0x00,0x22,0x00,0x31,0x02,0x01,0x00,0x13,0x02,0x01, 
	0x00,0x30,0x02,0x01,0x00,0x03,0x00,0x40,0x1a,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x32,0x00,0x23,0x02,0x01,0x00,0x41, 
	0x00,0x33,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x14,0x00,0x42,0x02,0x01,0x00,0x24,0x02,0x01,0x00,0x04,0x00,0x50,0x04,0x01, 
	0x02,0x01,0x00,0x43,0x00,0x34,0x02,0x01,0x00,0x51,0x00,0x15,0x1c,0x01,0x0e,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x52, 
	0x00,0x25,0x02,0x01,0x00,0x53,0x00,0x35,0x04,0x01,0x02,0x01,0x00,0x60,0x00,0x16,0x00,0x61,0x04,0x01,0x02,0x01,0x00,0x62, 
	0x00,0x26,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x05,0x00,0x06,0x00,0x44,0x02,0x01,0x00,0x54,0x00,0x45,0x12,0x01,0x0a,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x63,0x00,0x36,0x04,0x01,0x02,0x01,0x00,0x70,0x00,0x07,0x00,0x71,0x04,0x01,0x02,0x01,0x00,0x17, 
	0x00,0x64,0x02,0x01,0x00,0x46,0x00,0x72,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x27,0x02,0x01,0x00,0x55,0x00,0x73,0x02,0x01, 
	0x00,0x37,0x00,0x56,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x65,0x00,0x74,0x02,0x01,0x00,0x47,0x00,0x66,0x04,0x01,0x02,0x01, 
	0x00,0x75,0x00,0x57,0x02,0x01,0x00,0x76,0x02,0x01,0x00,0x67,0x00,0x77, 
	};

	static const uint8 table13[][2]={
	0x02,0x01,0x00,0x00,0x06,0x01,0x02,0x01,0x00,0x10,0x02,0x01,0x00,0x01,0x00,0x11,0x1c,0x01,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x20,0x00,0x02,0x02,0x01,0x00,0x21,0x00,0x12,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x22,0x00,0x30,0x02,0x01,0x00,0x03, 
	0x00,0x31,0x06,0x01,0x02,0x01,0x00,0x13,0x02,0x01,0x00,0x32,0x00,0x23,0x04,0x01,0x02,0x01,0x00,0x40,0x00,0x04,0x00,0x41, 
	0x46,0x01,0x1c,0x01,0x0e,0x01,0x06,0x01,0x02,0x01,0x00,0x14,0x02,0x01,0x00,0x33,0x00,0x42,0x04,0x01,0x02,0x01,0x00,0x24, 
	0x00,0x50,0x02,0x01,0x00,0x43,0x00,0x34,0x04,0x01,0x02,0x01,0x00,0x51,0x00,0x15,0x04,0x01,0x02,0x01,0x00,0x05,0x00,0x52, 
	0x02,0x01,0x00,0x25,0x02,0x01,0x00,0x44,0x00,0x53,0x0e,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x60,0x00,0x06,0x02,0x01, 
	0x00,0x61,0x00,0x16,0x04,0x01,0x02,0x01,0x00,0x80,0x00,0x08,0x00,0x81,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x35, 
	0x00,0x62,0x02,0x01,0x00,0x26,0x00,0x54,0x04,0x01,0x02,0x01,0x00,0x45,0x00,0x63,0x02,0x01,0x00,0x36,0x00,0x70,0x06,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x07,0x00,0x55,0x00,0x71,0x02,0x01,0x00,0x17,0x02,0x01,0x00,0x27,0x00,0x37,0x48,0x01,0x18,0x01, 
	0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0x18,0x00,0x82,0x02,0x01,0x00,0x28,0x04,0x01,0x02,0x01,0x00,0x64,0x00,0x46,0x00,0x72, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x84,0x00,0x48,0x02,0x01,0x00,0x90,0x00,0x09,0x02,0x01,0x00,0x91,0x00,0x19,0x18,0x01, 
	0x0e,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x73,0x00,0x65,0x02,0x01,0x00,0x56,0x00,0x74,0x04,0x01,0x02,0x01,0x00,0x47, 
	0x00,0x66,0x00,0x83,0x06,0x01,0x02,0x01,0x00,0x38,0x02,0x01,0x00,0x75,0x00,0x57,0x02,0x01,0x00,0x92,0x00,0x29,0x0e,0x01, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x67,0x00,0x85,0x02,0x01,0x00,0x58,0x00,0x39,0x02,0x01,0x00,0x93,0x02,0x01,0x00,0x49, 
	0x00,0x86,0x06,0x01,0x02,0x01,0x00,0xa0,0x02,0x01,0x00,0x68,0x00,0x0a,0x02,0x01,0x00,0xa1,0x00,0x1a,0x44,0x01,0x18,0x01, 
	0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0xa2,0x00,0x2a,0x04,0x01,0x02,0x01,0x00,0x95,0x00,0x59,0x02,0x01,0x00,0xa3,0x00,0x3a, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x4a,0x00,0x96,0x02,0x01,0x00,0xb0,0x00,0x0b,0x02,0x01,0x00,0xb1,0x00,0x1b,0x14,0x01, 
	0x08,0x01,0x02,0x01,0x00,0xb2,0x04,0x01,0x02,0x01,0x00,0x76,0x00,0x77,0x00,0x94,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x87, 
	0x00,0x78,0x00,0xa4,0x04,0x01,0x02,0x01,0x00,0x69,0x00,0xa5,0x00,0x2b,0x0c,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x5a, 
	0x00,0x88,0x00,0xb3,0x02,0x01,0x00,0x3b,0x02,0x01,0x00,0x79,0x00,0xa6,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x6a,0x00,0xb4, 
	0x00,0xc0,0x04,0x01,0x02,0x01,0x00,0x0c,0x00,0x98,0x00,0xc1,0x3c,0x01,0x16,0x01,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x1c, 
	0x02,0x01,0x00,0x89,0x00,0xb5,0x02,0x01,0x00,0x5b,0x00,0xc2,0x04,0x01,0x02,0x01,0x00,0x2c,0x00,0x3c,0x04,0x01,0x02,0x01, 
	0x00,0xb6,0x00,0x6b,0x02,0x01,0x00,0xc4,0x00,0x4c,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xa8,0x00,0x8a,0x02,0x01, 
	0x00,0xd0,0x00,0x0d,0x02,0x01,0x00,0xd1,0x02,0x01,0x00,0x4b,0x02,0x01,0x00,0x97,0x00,0xa7,0x0c,0x01,0x06,0x01,0x02,0x01, 
	0x00,0xc3,0x02,0x01,0x00,0x7a,0x00,0x99,0x04,0x01,0x02,0x01,0x00,0xc5,0x00,0x5c,0x00,0xb7,0x04,0x01,0x02,0x01,0x00,0x1d, 
	0x00,0xd2,0x02,0x01,0x00,0x2d,0x02,0x01,0x00,0x7b,0x00,0xd3,0x34,0x01,0x1c,0x01,0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0x3d, 
	0x00,0xc6,0x04,0x01,0x02,0x01,0x00,0x6c,0x00,0xa9,0x02,0x01,0x00,0x9a,0x00,0xd4,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xb8, 
	0x00,0x8b,0x02,0x01,0x00,0x4d,0x00,0xc7,0x04,0x01,0x02,0x01,0x00,0x7c,0x00,0xd5,0x02,0x01,0x00,0x5d,0x00,0xe0,0x0a,0x01, 
	0x04,0x01,0x02,0x01,0x00,0xe1,0x00,0x1e,0x04,0x01,0x02,0x01,0x00,0x0e,0x00,0x2e,0x00,0xe2,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0xe3,0x00,0x6d,0x02,0x01,0x00,0x8c,0x00,0xe4,0x04,0x01,0x02,0x01,0x00,0xe5,0x00,0xba,0x00,0xf0,0x26,0x01,0x10,0x01, 
	0x04,0x01,0x02,0x01,0x00,0xf1,0x00,0x1f,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xaa,0x00,0x9b,0x00,0xb9,0x02,0x01,0x00,0x3e, 
	0x02,0x01,0x00,0xd6,0x00,0xc8,0x0c,0x01,0x06,0x01,0x02,0x01,0x00,0x4e,0x02,0x01,0x00,0xd7,0x00,0x7d,0x02,0x01,0x00,0xab, 
	0x02,0x01,0x00,0x5e,0x00,0xc9,0x06,0x01,0x02,0x01,0x00,0x0f,0x02,0x01,0x00,0x9c,0x00,0x6e,0x02,0x01,0x00,0xf2,0x00,0x2f, 
	0x20,0x01,0x10,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xd8,0x00,0x8d,0x00,0x3f,0x06,0x01,0x02,0x01,0x00,0xf3,0x02,0x01, 
	0x00,0xe6,0x00,0xca,0x02,0x01,0x00,0xf4,0x00,0x4f,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xbb,0x00,0xac,0x02,0x01,0x00,0xe7, 
	0x00,0xf5,0x04,0x01,0x02,0x01,0x00,0xd9,0x00,0x9d,0x02,0x01,0x00,0x5f,0x00,0xe8,0x1e,0x01,0x0c,0x01,0x06,0x01,0x02,0x01, 
	0x00,0x6f,0x02,0x01,0x00,0xf6,0x00,0xcb,0x04,0x01,0x02,0x01,0x00,0xbc,0x00,0xad,0x00,0xda,0x08,0x01,0x02,0x01,0x00,0xf7, 
	0x04,0x01,0x02,0x01,0x00,0x7e,0x00,0x7f,0x00,0x8e,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x9e,0x00,0xae,0x00,0xcc,0x02,0x01, 
	0x00,0xf8,0x00,0x8f,0x12,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xdb,0x00,0xbd,0x02,0x01,0x00,0xea,0x00,0xf9,0x04,0x01, 
	0x02,0x01,0x00,0x9f,0x00,0xeb,0x02,0x01,0x00,0xbe,0x02,0x01,0x00,0xcd,0x00,0xfa,0x0e,0x01,0x04,0x01,0x02,0x01,0x00,0xdd, 
	0x00,0xec,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xe9,0x00,0xaf,0x00,0xdc,0x02,0x01,0x00,0xce,0x00,0xfb,0x08,0x01,0x04,0x01, 
	0x02,0x01,0x00,0xbf,0x00,0xde,0x02,0x01,0x00,0xcf,0x00,0xee,0x04,0x01,0x02,0x01,0x00,0xdf,0x00,0xef,0x02,0x01,0x00,0xff, 
	0x02,0x01,0x00,0xed,0x02,0x01,0x00,0xfd,0x02,0x01,0x00,0xfc,0x00,0xfe, 
	};

	static const uint8 table15[][2]={
	0x10,0x01,0x06,0x01,0x02,0x01,0x00,0x00,0x02,0x01,0x00,0x10,0x00,0x01,0x02,0x01,0x00,0x11,0x04,0x01,0x02,0x01,0x00,0x20, 
	0x00,0x02,0x02,0x01,0x00,0x21,0x00,0x12,0x32,0x01,0x10,0x01,0x06,0x01,0x02,0x01,0x00,0x22,0x02,0x01,0x00,0x30,0x00,0x31, 
	0x06,0x01,0x02,0x01,0x00,0x13,0x02,0x01,0x00,0x03,0x00,0x40,0x02,0x01,0x00,0x32,0x00,0x23,0x0e,0x01,0x06,0x01,0x04,0x01, 
	0x02,0x01,0x00,0x04,0x00,0x14,0x00,0x41,0x04,0x01,0x02,0x01,0x00,0x33,0x00,0x42,0x02,0x01,0x00,0x24,0x00,0x43,0x0a,0x01, 
	0x06,0x01,0x02,0x01,0x00,0x34,0x02,0x01,0x00,0x50,0x00,0x05,0x02,0x01,0x00,0x51,0x00,0x15,0x04,0x01,0x02,0x01,0x00,0x52, 
	0x00,0x25,0x04,0x01,0x02,0x01,0x00,0x44,0x00,0x53,0x00,0x61,0x5a,0x01,0x24,0x01,0x12,0x01,0x0a,0x01,0x06,0x01,0x02,0x01, 
	0x00,0x35,0x02,0x01,0x00,0x60,0x00,0x06,0x02,0x01,0x00,0x16,0x00,0x62,0x04,0x01,0x02,0x01,0x00,0x26,0x00,0x54,0x02,0x01, 
	0x00,0x45,0x00,0x63,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x36,0x02,0x01,0x00,0x70,0x00,0x07,0x02,0x01,0x00,0x71,0x00,0x55, 
	0x04,0x01,0x02,0x01,0x00,0x17,0x00,0x64,0x02,0x01,0x00,0x72,0x00,0x27,0x18,0x01,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x46,0x00,0x73,0x02,0x01,0x00,0x37,0x00,0x65,0x04,0x01,0x02,0x01,0x00,0x56,0x00,0x80,0x02,0x01,0x00,0x08,0x00,0x74, 
	0x04,0x01,0x02,0x01,0x00,0x81,0x00,0x18,0x02,0x01,0x00,0x82,0x00,0x28,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x47, 
	0x00,0x66,0x02,0x01,0x00,0x83,0x00,0x38,0x04,0x01,0x02,0x01,0x00,0x75,0x00,0x57,0x02,0x01,0x00,0x84,0x00,0x48,0x06,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x90,0x00,0x19,0x00,0x91,0x04,0x01,0x02,0x01,0x00,0x92,0x00,0x76,0x02,0x01,0x00,0x67,0x00,0x29, 
	0x5c,0x01,0x24,0x01,0x12,0x01,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x85,0x00,0x58,0x04,0x01,0x02,0x01,0x00,0x09,0x00,0x77, 
	0x00,0x93,0x04,0x01,0x02,0x01,0x00,0x39,0x00,0x94,0x02,0x01,0x00,0x49,0x00,0x86,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x68, 
	0x02,0x01,0x00,0xa0,0x00,0x0a,0x02,0x01,0x00,0xa1,0x00,0x1a,0x04,0x01,0x02,0x01,0x00,0xa2,0x00,0x2a,0x02,0x01,0x00,0x95, 
	0x00,0x59,0x1a,0x01,0x0e,0x01,0x06,0x01,0x02,0x01,0x00,0xa3,0x02,0x01,0x00,0x3a,0x00,0x87,0x04,0x01,0x02,0x01,0x00,0x78, 
	0x00,0xa4,0x02,0x01,0x00,0x4a,0x00,0x96,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x69,0x00,0xb0,0x00,0xb1,0x04,0x01,0x02,0x01, 
	0x00,0x1b,0x00,0xa5,0x00,0xb2,0x0e,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x5a,0x00,0x2b,0x02,0x01,0x00,0x88,0x00,0x97, 
	0x02,0x01,0x00,0xb3,0x02,0x01,0x00,0x79,0x00,0x3b,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x6a,0x00,0xb4,0x02,0x01,0x00,0x4b, 
	0x00,0xc1,0x04,0x01,0x02,0x01,0x00,0x98,0x00,0x89,0x02,0x01,0x00,0x1c,0x00,0xb5,0x50,0x01,0x22,0x01,0x10,0x01,0x06,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x5b,0x00,0x2c,0x00,0xc2,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x0b,0x00,0xc0,0x00,0xa6,0x02,0x01, 
	0x00,0xa7,0x00,0x7a,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0xc3,0x00,0x3c,0x04,0x01,0x02,0x01,0x00,0x0c,0x00,0x99,0x00,0xb6, 
	0x04,0x01,0x02,0x01,0x00,0x6b,0x00,0xc4,0x02,0x01,0x00,0x4c,0x00,0xa8,0x14,0x01,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x8a, 
	0x00,0xc5,0x04,0x01,0x02,0x01,0x00,0xd0,0x00,0x5c,0x00,0xd1,0x04,0x01,0x02,0x01,0x00,0xb7,0x00,0x7b,0x02,0x01,0x00,0x1d, 
	0x02,0x01,0x00,0x0d,0x00,0x2d,0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0xd2,0x00,0xd3,0x04,0x01,0x02,0x01,0x00,0x3d,0x00,0xc6, 
	0x02,0x01,0x00,0x6c,0x00,0xa9,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x9a,0x00,0xb8,0x00,0xd4,0x04,0x01,0x02,0x01,0x00,0x8b, 
	0x00,0x4d,0x02,0x01,0x00,0xc7,0x00,0x7c,0x44,0x01,0x22,0x01,0x12,0x01,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0xd5,0x00,0x5d, 
	0x04,0x01,0x02,0x01,0x00,0xe0,0x00,0x0e,0x00,0xe1,0x04,0x01,0x02,0x01,0x00,0x1e,0x00,0xe2,0x02,0x01,0x00,0xaa,0x00,0x2e, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xb9,0x00,0x9b,0x02,0x01,0x00,0xe3,0x00,0xd6,0x04,0x01,0x02,0x01,0x00,0x6d,0x00,0x3e, 
	0x02,0x01,0x00,0xc8,0x00,0x8c,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xe4,0x00,0x4e,0x02,0x01,0x00,0xd7,0x00,0x7d, 
	0x04,0x01,0x02,0x01,0x00,0xe5,0x00,0xba,0x02,0x01,0x00,0xab,0x00,0x5e,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xc9,0x00,0x9c, 
	0x02,0x01,0x00,0xf1,0x00,0x1f,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xf0,0x00,0x6e,0x00,0xf2,0x02,0x01,0x00,0x2f,0x00,0xe6, 
	0x26,0x01,0x12,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xd8,0x00,0xf3,0x02,0x01,0x00,0x3f,0x00,0xf4,0x06,0x01,0x02,0x01, 
	0x00,0x4f,0x02,0x01,0x00,0x8d,0x00,0xd9,0x02,0x01,0x00,0xbb,0x00,0xca,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xac,0x00,0xe7, 
	0x02,0x01,0x00,0x7e,0x00,0xf5,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x9d,0x00,0x5f,0x02,0x01,0x00,0xe8,0x00,0x8e,0x02,0x01, 
	0x00,0xf6,0x00,0xcb,0x22,0x01,0x12,0x01,0x0a,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x0f,0x00,0xae,0x00,0x6f,0x02,0x01, 
	0x00,0xbc,0x00,0xda,0x04,0x01,0x02,0x01,0x00,0xad,0x00,0xf7,0x02,0x01,0x00,0x7f,0x00,0xe9,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x9e,0x00,0xcc,0x02,0x01,0x00,0xf8,0x00,0x8f,0x04,0x01,0x02,0x01,0x00,0xdb,0x00,0xbd,0x02,0x01,0x00,0xea,0x00,0xf9, 
	0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x9f,0x00,0xdc,0x02,0x01,0x00,0xcd,0x00,0xeb,0x04,0x01,0x02,0x01,0x00,0xbe, 
	0x00,0xfa,0x02,0x01,0x00,0xaf,0x00,0xdd,0x0e,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xec,0x00,0xce,0x00,0xfb,0x04,0x01, 
	0x02,0x01,0x00,0xbf,0x00,0xed,0x02,0x01,0x00,0xde,0x00,0xfc,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xcf,0x00,0xfd,0x00,0xee, 
	0x04,0x01,0x02,0x01,0x00,0xdf,0x00,0xfe,0x02,0x01,0x00,0xef,0x00,0xff, 
	};

	static const uint8 table16[][2]={
	0x02,0x01,0x00,0x00,0x06,0x01,0x02,0x01,0x00,0x10,0x02,0x01,0x00,0x01,0x00,0x11,0x2a,0x01,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x20,0x00,0x02,0x02,0x01,0x00,0x21,0x00,0x12,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x22,0x02,0x01,0x00,0x30,0x00,0x03, 
	0x02,0x01,0x00,0x31,0x00,0x13,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x32,0x00,0x23,0x04,0x01,0x02,0x01,0x00,0x40,0x00,0x04, 
	0x00,0x41,0x06,0x01,0x02,0x01,0x00,0x14,0x02,0x01,0x00,0x33,0x00,0x42,0x04,0x01,0x02,0x01,0x00,0x24,0x00,0x50,0x02,0x01, 
	0x00,0x43,0x00,0x34,0x8a,0x01,0x28,0x01,0x10,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x05,0x00,0x15,0x00,0x51,0x04,0x01, 
	0x02,0x01,0x00,0x52,0x00,0x25,0x04,0x01,0x02,0x01,0x00,0x44,0x00,0x35,0x00,0x53,0x0a,0x01,0x06,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x60,0x00,0x06,0x00,0x61,0x02,0x01,0x00,0x16,0x00,0x62,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x26,0x00,0x54,0x02,0x01, 
	0x00,0x45,0x00,0x63,0x04,0x01,0x02,0x01,0x00,0x36,0x00,0x70,0x00,0x71,0x28,0x01,0x12,0x01,0x08,0x01,0x02,0x01,0x00,0x17, 
	0x02,0x01,0x00,0x07,0x02,0x01,0x00,0x55,0x00,0x64,0x04,0x01,0x02,0x01,0x00,0x72,0x00,0x27,0x04,0x01,0x02,0x01,0x00,0x46, 
	0x00,0x65,0x00,0x73,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x37,0x02,0x01,0x00,0x56,0x00,0x08,0x02,0x01,0x00,0x80,0x00,0x81, 
	0x06,0x01,0x02,0x01,0x00,0x18,0x02,0x01,0x00,0x74,0x00,0x47,0x02,0x01,0x00,0x82,0x02,0x01,0x00,0x28,0x00,0x66,0x18,0x01, 
	0x0e,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x83,0x00,0x38,0x02,0x01,0x00,0x75,0x00,0x84,0x04,0x01,0x02,0x01,0x00,0x48, 
	0x00,0x90,0x00,0x91,0x06,0x01,0x02,0x01,0x00,0x19,0x02,0x01,0x00,0x09,0x00,0x76,0x02,0x01,0x00,0x92,0x00,0x29,0x0e,0x01, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x85,0x00,0x58,0x02,0x01,0x00,0x93,0x00,0x39,0x04,0x01,0x02,0x01,0x00,0xa0,0x00,0x0a, 
	0x00,0x1a,0x08,0x01,0x02,0x01,0x00,0xa2,0x02,0x01,0x00,0x67,0x02,0x01,0x00,0x57,0x00,0x49,0x06,0x01,0x02,0x01,0x00,0x94, 
	0x02,0x01,0x00,0x77,0x00,0x86,0x02,0x01,0x00,0xa1,0x02,0x01,0x00,0x68,0x00,0x95,0xdc,0x01,0x7e,0x01,0x32,0x01,0x1a,0x01, 
	0x0c,0x01,0x06,0x01,0x02,0x01,0x00,0x2a,0x02,0x01,0x00,0x59,0x00,0x3a,0x02,0x01,0x00,0xa3,0x02,0x01,0x00,0x87,0x00,0x78, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xa4,0x00,0x4a,0x02,0x01,0x00,0x96,0x00,0x69,0x04,0x01,0x02,0x01,0x00,0xb0,0x00,0x0b, 
	0x00,0xb1,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x1b,0x00,0xb2,0x02,0x01,0x00,0x2b,0x02,0x01,0x00,0xa5,0x00,0x5a,0x06,0x01, 
	0x02,0x01,0x00,0xb3,0x02,0x01,0x00,0xa6,0x00,0x6a,0x04,0x01,0x02,0x01,0x00,0xb4,0x00,0x4b,0x02,0x01,0x00,0x0c,0x00,0xc1, 
	0x1e,0x01,0x0e,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xb5,0x00,0xc2,0x00,0x2c,0x04,0x01,0x02,0x01,0x00,0xa7,0x00,0xc3, 
	0x02,0x01,0x00,0x6b,0x00,0xc4,0x08,0x01,0x02,0x01,0x00,0x1d,0x04,0x01,0x02,0x01,0x00,0x88,0x00,0x97,0x00,0x3b,0x04,0x01, 
	0x02,0x01,0x00,0xd1,0x00,0xd2,0x02,0x01,0x00,0x2d,0x00,0xd3,0x12,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x1e,0x00,0x2e, 
	0x00,0xe2,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x79,0x00,0x98,0x00,0xc0,0x02,0x01,0x00,0x1c,0x02,0x01,0x00,0x89,0x00,0x5b, 
	0x0e,0x01,0x06,0x01,0x02,0x01,0x00,0x3c,0x02,0x01,0x00,0x7a,0x00,0xb6,0x04,0x01,0x02,0x01,0x00,0x4c,0x00,0x99,0x02,0x01, 
	0x00,0xa8,0x00,0x8a,0x06,0x01,0x02,0x01,0x00,0x0d,0x02,0x01,0x00,0xc5,0x00,0x5c,0x04,0x01,0x02,0x01,0x00,0x3d,0x00,0xc6, 
	0x02,0x01,0x00,0x6c,0x00,0x9a,0x58,0x01,0x56,0x01,0x24,0x01,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x8b,0x00,0x4d, 
	0x02,0x01,0x00,0xc7,0x00,0x7c,0x04,0x01,0x02,0x01,0x00,0xd5,0x00,0x5d,0x02,0x01,0x00,0xe0,0x00,0x0e,0x08,0x01,0x02,0x01, 
	0x00,0xe3,0x04,0x01,0x02,0x01,0x00,0xd0,0x00,0xb7,0x00,0x7b,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xa9,0x00,0xb8,0x00,0xd4, 
	0x02,0x01,0x00,0xe1,0x02,0x01,0x00,0xaa,0x00,0xb9,0x18,0x01,0x0a,0x01,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x9b,0x00,0xd6, 
	0x00,0x6d,0x02,0x01,0x00,0x3e,0x00,0xc8,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x8c,0x00,0xe4,0x00,0x4e,0x04,0x01,0x02,0x01, 
	0x00,0xd7,0x00,0xe5,0x02,0x01,0x00,0xba,0x00,0xab,0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0x9c,0x00,0xe6,0x04,0x01,0x02,0x01, 
	0x00,0x6e,0x00,0xd8,0x02,0x01,0x00,0x8d,0x00,0xbb,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xe7,0x00,0x9d,0x02,0x01,0x00,0xe8, 
	0x00,0x8e,0x04,0x01,0x02,0x01,0x00,0xcb,0x00,0xbc,0x00,0x9e,0x00,0xf1,0x02,0x01,0x00,0x1f,0x02,0x01,0x00,0x0f,0x00,0x2f, 
	0x42,0x01,0x38,0x01,0x02,0x01,0x00,0xf2,0x34,0x01,0x32,0x01,0x14,0x01,0x08,0x01,0x02,0x01,0x00,0xbd,0x02,0x01,0x00,0x5e, 
	0x02,0x01,0x00,0x7d,0x00,0xc9,0x06,0x01,0x02,0x01,0x00,0xca,0x02,0x01,0x00,0xac,0x00,0x7e,0x04,0x01,0x02,0x01,0x00,0xda, 
	0x00,0xad,0x00,0xcc,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0xae,0x02,0x01,0x00,0xdb,0x00,0xdc,0x02,0x01,0x00,0xcd,0x00,0xbe, 
	0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xeb,0x00,0xed,0x00,0xee,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0xd9,0x00,0xea,0x00,0xe9, 
	0x02,0x01,0x00,0xde,0x04,0x01,0x02,0x01,0x00,0xdd,0x00,0xec,0x00,0xce,0x00,0x3f,0x00,0xf0,0x04,0x01,0x02,0x01,0x00,0xf3, 
	0x00,0xf4,0x02,0x01,0x00,0x4f,0x02,0x01,0x00,0xf5,0x00,0x5f,0x0a,0x01,0x02,0x01,0x00,0xff,0x04,0x01,0x02,0x01,0x00,0xf6, 
	0x00,0x6f,0x02,0x01,0x00,0xf7,0x00,0x7f,0x0c,0x01,0x06,0x01,0x02,0x01,0x00,0x8f,0x02,0x01,0x00,0xf8,0x00,0xf9,0x04,0x01, 
	0x02,0x01,0x00,0x9f,0x00,0xfa,0x00,0xaf,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xfb,0x00,0xbf,0x02,0x01,0x00,0xfc,0x00,0xcf, 
	0x04,0x01,0x02,0x01,0x00,0xfd,0x00,0xdf,0x02,0x01,0x00,0xfe,0x00,0xef, 
	};

	static const uint8 table24[][2]={
	0x3c,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x00,0x00,0x10,0x02,0x01,0x00,0x01,0x00,0x11,0x0e,0x01,0x06,0x01,0x04,0x01, 
	0x02,0x01,0x00,0x20,0x00,0x02,0x00,0x21,0x02,0x01,0x00,0x12,0x02,0x01,0x00,0x22,0x02,0x01,0x00,0x30,0x00,0x03,0x0e,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x31,0x00,0x13,0x04,0x01,0x02,0x01,0x00,0x32,0x00,0x23,0x04,0x01,0x02,0x01,0x00,0x40,0x00,0x04, 
	0x00,0x41,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x14,0x00,0x33,0x02,0x01,0x00,0x42,0x00,0x24,0x06,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x43,0x00,0x34,0x00,0x51,0x06,0x01,0x04,0x01,0x02,0x01,0x00,0x50,0x00,0x05,0x00,0x15,0x02,0x01,0x00,0x52,0x00,0x25, 
	0xfa,0x01,0x62,0x01,0x22,0x01,0x12,0x01,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x44,0x00,0x53,0x02,0x01,0x00,0x35,0x02,0x01, 
	0x00,0x60,0x00,0x06,0x04,0x01,0x02,0x01,0x00,0x61,0x00,0x16,0x02,0x01,0x00,0x62,0x00,0x26,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x54,0x00,0x45,0x02,0x01,0x00,0x63,0x00,0x36,0x04,0x01,0x02,0x01,0x00,0x71,0x00,0x55,0x02,0x01,0x00,0x64,0x00,0x46, 
	0x20,0x01,0x0e,0x01,0x06,0x01,0x02,0x01,0x00,0x72,0x02,0x01,0x00,0x27,0x00,0x37,0x02,0x01,0x00,0x73,0x04,0x01,0x02,0x01, 
	0x00,0x70,0x00,0x07,0x00,0x17,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0x65,0x00,0x56,0x04,0x01,0x02,0x01,0x00,0x80,0x00,0x08, 
	0x00,0x81,0x04,0x01,0x02,0x01,0x00,0x74,0x00,0x47,0x02,0x01,0x00,0x18,0x00,0x82,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0x28,0x00,0x66,0x02,0x01,0x00,0x83,0x00,0x38,0x04,0x01,0x02,0x01,0x00,0x75,0x00,0x57,0x02,0x01,0x00,0x84,0x00,0x48, 
	0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x91,0x00,0x19,0x02,0x01,0x00,0x92,0x00,0x76,0x04,0x01,0x02,0x01,0x00,0x67,0x00,0x29, 
	0x02,0x01,0x00,0x85,0x00,0x58,0x5c,0x01,0x22,0x01,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x93,0x00,0x39,0x02,0x01, 
	0x00,0x94,0x00,0x49,0x04,0x01,0x02,0x01,0x00,0x77,0x00,0x86,0x02,0x01,0x00,0x68,0x00,0xa1,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0xa2,0x00,0x2a,0x02,0x01,0x00,0x95,0x00,0x59,0x04,0x01,0x02,0x01,0x00,0xa3,0x00,0x3a,0x02,0x01,0x00,0x87,0x02,0x01, 
	0x00,0x78,0x00,0x4a,0x16,0x01,0x0c,0x01,0x04,0x01,0x02,0x01,0x00,0xa4,0x00,0x96,0x04,0x01,0x02,0x01,0x00,0x69,0x00,0xb1, 
	0x02,0x01,0x00,0x1b,0x00,0xa5,0x06,0x01,0x02,0x01,0x00,0xb2,0x02,0x01,0x00,0x5a,0x00,0x2b,0x02,0x01,0x00,0x88,0x00,0xb3, 
	0x10,0x01,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x90,0x02,0x01,0x00,0x09,0x00,0xa0,0x02,0x01,0x00,0x97,0x00,0x79,0x04,0x01, 
	0x02,0x01,0x00,0xa6,0x00,0x6a,0x00,0xb4,0x0c,0x01,0x06,0x01,0x02,0x01,0x00,0x1a,0x02,0x01,0x00,0x0a,0x00,0xb0,0x02,0x01, 
	0x00,0x3b,0x02,0x01,0x00,0x0b,0x00,0xc0,0x04,0x01,0x02,0x01,0x00,0x4b,0x00,0xc1,0x02,0x01,0x00,0x98,0x00,0x89,0x43,0x01, 
	0x22,0x01,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x1c,0x00,0xb5,0x02,0x01,0x00,0x5b,0x00,0xc2,0x04,0x01,0x02,0x01, 
	0x00,0x2c,0x00,0xa7,0x02,0x01,0x00,0x7a,0x00,0xc3,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x3c,0x02,0x01,0x00,0x0c,0x00,0xd0, 
	0x02,0x01,0x00,0xb6,0x00,0x6b,0x04,0x01,0x02,0x01,0x00,0xc4,0x00,0x4c,0x02,0x01,0x00,0x99,0x00,0xa8,0x10,0x01,0x08,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x8a,0x00,0xc5,0x02,0x01,0x00,0x5c,0x00,0xd1,0x04,0x01,0x02,0x01,0x00,0xb7,0x00,0x7b,0x02,0x01, 
	0x00,0x1d,0x00,0xd2,0x09,0x01,0x04,0x01,0x02,0x01,0x00,0x2d,0x00,0xd3,0x02,0x01,0x00,0x3d,0x00,0xc6,0x55,0xfa,0x04,0x01, 
	0x02,0x01,0x00,0x6c,0x00,0xa9,0x02,0x01,0x00,0x9a,0x00,0xd4,0x20,0x01,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xb8, 
	0x00,0x8b,0x02,0x01,0x00,0x4d,0x00,0xc7,0x04,0x01,0x02,0x01,0x00,0x7c,0x00,0xd5,0x02,0x01,0x00,0x5d,0x00,0xe1,0x08,0x01, 
	0x04,0x01,0x02,0x01,0x00,0x1e,0x00,0xe2,0x02,0x01,0x00,0xaa,0x00,0xb9,0x04,0x01,0x02,0x01,0x00,0x9b,0x00,0xe3,0x02,0x01, 
	0x00,0xd6,0x00,0x6d,0x14,0x01,0x0a,0x01,0x06,0x01,0x02,0x01,0x00,0x3e,0x02,0x01,0x00,0x2e,0x00,0x4e,0x02,0x01,0x00,0xc8, 
	0x00,0x8c,0x04,0x01,0x02,0x01,0x00,0xe4,0x00,0xd7,0x04,0x01,0x02,0x01,0x00,0x7d,0x00,0xab,0x00,0xe5,0x0a,0x01,0x04,0x01, 
	0x02,0x01,0x00,0xba,0x00,0x5e,0x02,0x01,0x00,0xc9,0x02,0x01,0x00,0x9c,0x00,0x6e,0x08,0x01,0x02,0x01,0x00,0xe6,0x02,0x01, 
	0x00,0x0d,0x02,0x01,0x00,0xe0,0x00,0x0e,0x04,0x01,0x02,0x01,0x00,0xd8,0x00,0x8d,0x02,0x01,0x00,0xbb,0x00,0xca,0x4a,0x01, 
	0x02,0x01,0x00,0xff,0x40,0x01,0x3a,0x01,0x20,0x01,0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xac,0x00,0xe7,0x02,0x01, 
	0x00,0x7e,0x00,0xd9,0x04,0x01,0x02,0x01,0x00,0x9d,0x00,0xe8,0x02,0x01,0x00,0x8e,0x00,0xcb,0x08,0x01,0x04,0x01,0x02,0x01, 
	0x00,0xbc,0x00,0xda,0x02,0x01,0x00,0xad,0x00,0xe9,0x04,0x01,0x02,0x01,0x00,0x9e,0x00,0xcc,0x02,0x01,0x00,0xdb,0x00,0xbd, 
	0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xea,0x00,0xae,0x02,0x01,0x00,0xdc,0x00,0xcd,0x04,0x01,0x02,0x01,0x00,0xeb, 
	0x00,0xbe,0x02,0x01,0x00,0xdd,0x00,0xec,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xce,0x00,0xed,0x02,0x01,0x00,0xde,0x00,0xee, 
	0x00,0x0f,0x04,0x01,0x02,0x01,0x00,0xf0,0x00,0x1f,0x00,0xf1,0x04,0x01,0x02,0x01,0x00,0xf2,0x00,0x2f,0x02,0x01,0x00,0xf3, 
	0x00,0x3f,0x12,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xf4,0x00,0x4f,0x02,0x01,0x00,0xf5,0x00,0x5f,0x04,0x01,0x02,0x01, 
	0x00,0xf6,0x00,0x6f,0x02,0x01,0x00,0xf7,0x02,0x01,0x00,0x7f,0x00,0x8f,0x0a,0x01,0x04,0x01,0x02,0x01,0x00,0xf8,0x00,0xf9, 
	0x04,0x01,0x02,0x01,0x00,0x9f,0x00,0xaf,0x00,0xfa,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0xfb,0x00,0xbf,0x02,0x01,0x00,0xfc, 
	0x00,0xcf,0x04,0x01,0x02,0x01,0x00,0xfd,0x00,0xdf,0x02,0x01,0x00,0xfe,0x00,0xef, 
	};

	static const uint8 table32[][2]={
	0x02,0x01,0x00,0x00,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x08,0x00,0x04,0x02,0x01,0x00,0x01,0x00,0x02,0x08,0x01,0x04,0x01, 
	0x02,0x01,0x00,0x0c,0x00,0x0a,0x02,0x01,0x00,0x03,0x00,0x06,0x06,0x01,0x02,0x01,0x00,0x09,0x02,0x01,0x00,0x05,0x00,0x07, 
	0x04,0x01,0x02,0x01,0x00,0x0e,0x00,0x0d,0x02,0x01,0x00,0x0f,0x00,0x0b, 
	};

	static const uint8 table33[][2]={
	0x10,0x01,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x00,0x00,0x01,0x02,0x01,0x00,0x02,0x00,0x03,0x04,0x01,0x02,0x01,0x00,0x04, 
	0x00,0x05,0x02,0x01,0x00,0x06,0x00,0x07,0x08,0x01,0x04,0x01,0x02,0x01,0x00,0x08,0x00,0x09,0x02,0x01,0x00,0x0a,0x00,0x0b, 
	0x04,0x01,0x02,0x01,0x00,0x0c,0x00,0x0d,0x02,0x01,0x00,0x0e,0x00,0x0f, 
	};

	static const unsigned hufftbl_15_shortcut[8]={		// starting node for 000..111
		156,
		67,
		33,
		18,
		9,
		8,
		4,
		3,
	};

	static const unsigned hufftbl_24_shortcut[16]={		// starting node for 0000..1111
		487, 470, 398, 397,
		251, 160, 96, 63,
		37, 24, 16, 11,
		8, 7, 5, 4
	};
}

const VDMPEGAudioDecoder::L3HuffmanTableDescriptor VDMPEGAudioDecoder::sL3HuffmanTables[]={
	{ NULL,      0,  0,  0 },
	{ table1,    7,  2,  0 },
	{ table2,   17,  3,  0 },
	{ table3,   17,  3,  0 },
	{ NULL,      0,  0,  0 },
	{ table5,   31,  4,  0 },
	{ table6,   31,  4,  0 },
	{ table7,   71,  6,  0 },
	{ table8,   71,  6,  0 },
	{ table9,   71,  6,  0 },
	{ table10, 127,  8,  0 },
	{ table11, 127,  8,  0 },
	{ table12, 127,  8,  0 },
	{ table13, 511, 16,  0 },
	{ NULL,      0,  0,  0 },
	{ table15, 511, 16,  0 },
	{ table16, 511, 16,  1 },
	{ table16, 511, 16,  2 },
	{ table16, 511, 16,  3 },
	{ table16, 511, 16,  4 },
	{ table16, 511, 16,  6 },
	{ table16, 511, 16,  8 },
	{ table16, 511, 16, 10 },
	{ table16, 511, 16, 13 },
	{ table24, 512, 16,  4 },
	{ table24, 512, 16,  5 },
	{ table24, 512, 16,  6 },
	{ table24, 512, 16,  7 },
	{ table24, 512, 16,  8 },
	{ table24, 512, 16,  9 },
	{ table24, 512, 16, 11 },
	{ table24, 512, 16, 13 },
	{ table32, 0, 0, 0 },
	{ table33, 0, 0, 0 },
};

#pragma warning(push)
#pragma warning(disable: 4035)		// warning C4035: 'rdtsc': no return value
static inline uint64 rdtsc() {
	__asm {
		rdtsc
	}
}
#pragma warning(pop)

void VDMPEGAudioDecoder::DecodeHuffmanValues(VDMPEGAudioHuffBitReader& bitreader, sint32 *dst, unsigned tableid, unsigned pairs) {
#if 0
	unsigned foo[8];
	for(int i=0; i<8; ++i) {
		unsigned j=0;

		j += table15[j][(i>>0)&1];
		j += table15[j][(i>>1)&1];
		j += table15[j][(i>>2)&1];
		foo[i] = j;
	}

	__asm int 3
#endif

	if (!tableid) {
		while(pairs-- > 0) {
			*dst++ = 0;
			*dst++ = 0;
		}
		return;
	}

	VDMPEGAudioHuffBitReader bits(bitreader);

	const L3HuffmanTableDescriptor& tableinfo = sL3HuffmanTables[tableid];

	const uint8 (*const table)[2] = tableinfo.table;
	const unsigned xybits = tableinfo.bits;
	const unsigned linbits = tableinfo.linbits;

#ifdef RDTSC_PROFILE
	static uint64 ticks[32]={0};

	ticks[tableid] -= rdtsc();
#endif

	if (tableid == 1) {
		while(pairs-- > 0) {
			int v;

			v = bits.peek(5);
			bits.consume(hufftbl_1_fast[v].bits);

			dst[0] = hufftbl_1_fast[v].x;
			dst[1] = hufftbl_1_fast[v].y;
			dst+=2;
		}
	} else if (tableid == 2) {
		while(pairs-- > 0) {
			int v;

			v = bits.peek(5);
			if (v < 4) {
				v = bits.peek(8);
				bits.consume(hufftbl_2_3_hi[v].bits);

				dst[0] = hufftbl_2_3_hi[v].x;
				dst[1] = hufftbl_2_3_hi[v].y;
			} else {
				bits.consume(hufftbl_2_lo[v-4].bits);

				dst[0] = hufftbl_2_lo[v-4].x;
				dst[1] = hufftbl_2_lo[v-4].y;
			}
			dst+=2;
		}
	} else if (tableid == 3) {
		while(pairs-- > 0) {
			int v;

			v = bits.peek(4);
			if (v < 2) {
				v = bits.peek(8);
				bits.consume(hufftbl_2_3_hi[v].bits);

				dst[0] = hufftbl_2_3_hi[v].x;
				dst[1] = hufftbl_2_3_hi[v].y;
			} else {
				bits.consume(hufftbl_3_lo[v-2].bits);

				dst[0] = hufftbl_3_lo[v-2].x;
				dst[1] = hufftbl_3_lo[v-2].y;
			}
			dst+=2;
		}
	} else if (tableid == 5) {
		while(pairs-- > 0) {
			unsigned v = bits.peek(5);

			if (v >= 4) {
				bits.consume(hufftbl_5_hi[v-4].bits);

				dst[0] = hufftbl_5_hi[v-4].x;
				dst[1] = hufftbl_5_hi[v-4].y;
			} else {
				bits.consume(3);

				unsigned idx = 8;

				while(table5[idx][0]) {
					unsigned i = bits.get(1);

					idx += table5[idx][i];
				}

				int x = table5[idx][1] >> 4;
				int y = table5[idx][1] & 15;

				if (x && bits.getbit())
					x = -x;

				if (y && bits.getbit())
					y = -y;

				dst[0] = x;
				dst[1] = y;
			}

			dst += 2;
		}
	} else if (tableid == 6) {
		while(pairs-- > 0) {
			unsigned v = bits.peek(6);

			if (v >= 10) {
				bits.consume(hufftbl_6_hi[v-10].bits);

				dst[0] = hufftbl_6_hi[v-10].x;
				dst[1] = hufftbl_6_hi[v-10].y;
			} else {
				bits.consume(2);

				unsigned idx = 12;

				while(table6[idx][0]) {
					unsigned i = bits.get(1);

					idx += table6[idx][i];
				}

				int x = table6[idx][1] >> 4;
				int y = table6[idx][1] & 15;

				if (x && bits.getbit())
					x = -x;

				if (y && bits.getbit())
					y = -y;

				dst[0] = x;
				dst[1] = y;
			}

			dst += 2;
		}
	} else if (tableid == 15) {
		while(pairs-- > 0) {
			unsigned idx = hufftbl_15_shortcut[bits.get(3)];

			while(table[idx][0]) {
				unsigned i = bits.get(1);

				idx += table15[idx][i];
			}

			int x = table15[idx][1] >> 4;
			int y = table15[idx][1] & 15;

			if (x && bits.getbit())
				x = -x;

			if (y && bits.getbit())
				y = -y;

			dst[0] = x;
			dst[1] = y;
			dst += 2;
		}
	} else if (tableid >= 24) {
		while(pairs-- > 0) {
			unsigned idx = hufftbl_24_shortcut[bits.get(4)];

			while(table[idx][0]) {
				unsigned delta;
				unsigned i = bits.get(1);

				do {
					idx += delta = table[idx][i];
				} while(delta >= 250);
			}

			int x = table[idx][1] >> 4;
			int y = table[idx][1] & 15;

			if (x == 15)
				x += bits.get(linbits);

			if (x && bits.getbit())
				x = -x;

			if (y == 15)
				y += bits.get(linbits);

			if (y && bits.getbit())
				y = -y;

			dst[0] = x;
			dst[1] = y;
			dst += 2;
		}
	} else if (linbits) {
		while(pairs-- > 0) {
			unsigned idx = 0;

			while(table[idx][0]) {
				unsigned i = bits.get(1);

				idx += table[idx][i];
			}

			int x = table[idx][1] >> 4;
			int y = table[idx][1] & 15;

			if (x == 15 && linbits)
				x += bits.get(linbits);

			if (x && bits.getbit())
				x = -x;

			if (y == 15 && linbits)
				y += bits.get(linbits);

			if (y && bits.getbit())
				y = -y;

			dst[0] = x;
			dst[1] = y;
			dst += 2;
		}
	} else {
		while(pairs-- > 0) {
			unsigned idx = 0;

			while(table[idx][0]) {
				unsigned i = bits.get(1);

				idx += table[idx][i];
			}

			int x = table[idx][1] >> 4;
			int y = table[idx][1] & 15;

			if (x && bits.getbit())
				x = -x;

			if (y && bits.getbit())
				y = -y;

			dst[0] = x;
			dst[1] = y;
			dst += 2;
		}
	}
	bitreader = bits;

#ifdef RDTSC_PROFILE
	ticks[tableid] += rdtsc();

	static int times = 0;

	if (++times == 4096) {
		times = 0;

		static char buf[1024];

		for(int i=0; i<32; ++i) {
			wsprintf(buf, "table %2d: %u ticks\n",i, (unsigned)ticks[i]);
			OutputDebugString(buf);
			ticks[i] = 0;
		}
	}
#endif
}
