//	VirtualDub - Video processing and capture application
//	Copyright (C) 1998-2001 Avery Lee
//
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef f_DUBSTATUS_H
#define f_DUBSTATUS_H

typedef void (*DubPositionCallback)(LONG start_pos, LONG cur_pos, LONG end_pos, int nProgress);

class DubAudioStreamInfo;
class DubVideoStreamInfo;
class AudioSource;
class VideoSource;
class InputFile;
class AudioStream;
class IDubber;
class DubOptions;

class __declspec(novtable) IDubStatusHandler {
public:
	virtual ~IDubStatusHandler() {};
	virtual void InitLinks(DubAudioStreamInfo	*painfo,
		DubVideoStreamInfo	*pvinfo,
		AudioSource			*aSrc,
		VideoSource			*vSrc,
		InputFile			*pInput,
		AudioStream			*audioStreamSource,

		IDubber				*pDubber,
		DubOptions			*opt)=0;
	virtual void NotifyNewFrame(long lSize)=0;
	virtual HWND Display(HWND hwndParent, int iInitialPriority)=0;
	virtual void Destroy()=0;
	virtual void SetPositionCallback(DubPositionCallback dpc)	=0;
	virtual bool ToggleStatus()=0;
	virtual void SetLastPosition(LONG pos)=0;
	virtual void Freeze()=0;
	virtual bool isVisible()=0;
	virtual bool isFrameVisible(bool)=0;
	virtual bool ToggleFrame(bool)=0;
};

IDubStatusHandler *CreateDubStatusHandler();

#ifndef f_DUBSTATUS_CPP
extern const char *const g_szDubPriorities[];
#endif

#endif
