/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JWindow;

public class DoubleCleaner
extends JFrame {
    Container contentPane;
    FileAccess fileAccess = new FileAccess();
    DoubleSearcher doubleSearcher;
    FilesPanel filesPanel = new FilesPanel();
    FilterPanel filterPanel = new FilterPanel();
    JMenuBar menuBar = new JMenuBar();
    JMenu viewMenu = new JMenu("View");
    JMenuItem viewFilterPanel = new JMenuItem("Filter");
    JMenuItem viewAboutPanel = new JMenuItem("About");
    JMenuItem exitMenu = new JMenuItem("Exit");
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private JWindow window = new JWindow();
    private JLabel label;

    public DoubleCleaner() {
        super("Double Cleaner V1.0 by Markus Krebs");
        this.showStartPicture();
        this.contentPane = this.getContentPane();
        this.showFilterPanel();
        this.viewFilterPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DoubleCleaner.this.showFilterPanel();
            }
        });
        this.viewAboutPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(null, new AboutPanel());
            }
        });
        this.exitMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.viewMenu.add(this.viewFilterPanel);
        this.viewMenu.add(this.viewAboutPanel);
        this.viewMenu.add(this.exitMenu);
        this.menuBar.add(this.viewMenu);
        this.setJMenuBar(this.menuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)this).setLocation(20, 20);
        ((Component)this).setSize(new Dimension(500, 400));
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closeStartPicture();
        this.show();
    }

    public void showFilterPanel() {
        JButton jButton = new JButton("START comparing");
        jButton.setToolTipText("Start comparing files...(-> Show double Files)");
        this.contentPane.removeAll();
        this.contentPane.add((Component)this.filterPanel, "Center");
        this.contentPane.add((Component)jButton, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DoubleCleaner.this.showFilesPanel();
            }
        });
        this.contentPane.repaint();
        this.contentPane.validate();
    }

    public void showFilesPanel() {
        this.fileAccess.setFilter(this.filterPanel.getFilterPrefix(), this.filterPanel.getFilterSuffix(), this.filterPanel.getFilterPrefixMode(), this.filterPanel.getFilterSuffixMode());
        this.doubleSearcher = new DoubleSearcher(this.fileAccess);
        this.doubleSearcher.startReading();
        int n = JOptionPane.showConfirmDialog(null, this.doubleSearcher, "Please wait (Reading Files)", 2);
        this.doubleSearcher.stopReading();
        if (n == 0) {
            Vector vector = this.doubleSearcher.getDoubleFiles();
            if (vector == null) {
                JOptionPane.showMessageDialog(null, "Reading canceled");
                return;
            }
            if (vector.size() == 0) {
                JOptionPane.showMessageDialog(null, "No matching Files");
                return;
            }
            this.filesPanel.setFileAccess(this.fileAccess);
            this.filesPanel.setDoubleFilesVector(vector);
            this.contentPane.removeAll();
            this.contentPane.add((Component)this.filesPanel, "Center");
            this.contentPane.repaint();
            this.contentPane.validate();
        }
    }

    private void showStartPicture() {
        String string = "images/StartPicture.jpg";
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        try {
            int n = 0;
            int n2 = 0;
            byte[] byArray = new byte[50000];
            while (inputStream.available() > 0) {
                n2 = inputStream.read(byArray, n, 1000);
                n += n2;
            }
            int n3 = n - n2;
            byte[] byArray2 = new byte[n3];
            int n4 = 0;
            while (n4 < n3) {
                byArray2[n4] = byArray[n4];
                ++n4;
            }
            image = toolkit.createImage(byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.label = new JLabel(new ImageIcon(image));
        this.label.setBorder(BorderFactory.createRaisedBevelBorder());
        this.window.getContentPane().add((Component)this.label, "Center");
        this.centerWindow();
        this.window.show();
    }

    private void closeStartPicture() {
        this.window.dispose();
    }

    private void centerWindow() {
        Dimension dimension = this.toolkit.getScreenSize();
        Dimension dimension2 = this.label.getPreferredSize();
        int n = dimension2.width;
        int n2 = dimension2.height;
        ((Component)this.window).setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        this.window.pack();
    }

    public static void main(String[] stringArray) {
        DoubleCleaner doubleCleaner = new DoubleCleaner();
    }
}

