/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

class DoubleSearcher
extends JPanel {
    JLabel progressLabel = new JLabel("Read Files ...");
    JProgressBar progressBar = new JProgressBar();
    Thread thread;
    FileAccess fileAccess;
    Vector vecAllFiles;
    Vector vecDoubleFiles;
    int takenFiles;
    int counterComparedFiles;
    boolean stopReadingFlag;

    public DoubleSearcher(FileAccess fileAccess) {
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(Color.red);
        this.progressBar.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)this.progressLabel, "North");
        this.add((Component)this.progressBar, "South");
        this.fileAccess = fileAccess;
        fileAccess.setProgressLabel(this.progressLabel);
        fileAccess.setProgressBar(this.progressBar);
    }

    public void startReading() {
        this.vecAllFiles = null;
        this.vecDoubleFiles = null;
        this.fileAccess.setStopFlag(false);
        this.stopReadingFlag = false;
        this.thread = new Thread(new Runnable(){

            public void run() {
                DoubleSearcher.this.startAll();
            }
        });
        this.thread.start();
    }

    public void stopReading() {
        this.fileAccess.stopReading();
        this.thread = null;
    }

    public void resetCounter() {
        this.counterComparedFiles = 0;
    }

    public void increaseCounter() {
        ++this.counterComparedFiles;
        this.progressBar.setValue(this.getCurrentCounterValue());
    }

    public int getCurrentCounterValue() {
        return this.counterComparedFiles;
    }

    public int getMaxCounterValue() {
        return this.takenFiles;
    }

    public void startAll() {
        this.startReadingFiles();
        this.startComparingFiles();
    }

    public void startReadingFiles() {
        this.vecAllFiles = this.fileAccess.getAllFiles();
        this.takenFiles = this.vecAllFiles.size();
    }

    public void startComparingFiles() {
        this.progressLabel.setText("Files to compare: " + this.takenFiles);
        this.progressBar.setMaximum(this.getMaxCounterValue());
        this.vecDoubleFiles = this.searchDoubleFilenames(this.vecAllFiles);
        this.progressBar.setValue(this.getMaxCounterValue());
        this.progressBar.setString("Ready (Press OK)");
    }

    public void setFileAccess(FileAccess fileAccess) {
        this.fileAccess = fileAccess;
    }

    public Vector getDoubleFiles() {
        return this.vecDoubleFiles;
    }

    private Vector searchDoubleFilenames(Vector vector) {
        Object[] objectArray = vector.toArray();
        Arrays.sort(objectArray, new SortByNameComparator());
        Vector<Vector> vector2 = new Vector<Vector>();
        int n = 0;
        while (n < objectArray.length - 1) {
            String string;
            File file = (File)objectArray[n];
            File file2 = (File)objectArray[n + 1];
            String string2 = file.getName().toUpperCase();
            if (string2.compareTo(string = file2.getName().toUpperCase()) == 0) {
                Vector vector3 = new Vector();
                vector3.add(objectArray[n]);
                do {
                    vector3.add(objectArray[++n]);
                } while (n + 1 < objectArray.length && string2.compareTo(string = (file2 = (File)objectArray[n + 1]).getName().toUpperCase()) == 0);
                vector3 = this.searchDoubleFiles(vector3);
                if (this.thread == null) {
                    return null;
                }
                if (vector3.size() >= 1) {
                    vector2.add(vector3);
                }
            } else {
                this.increaseCounter();
            }
            ++n;
        }
        return vector2;
    }

    private Vector searchDoubleFiles(Vector vector) {
        int n = vector.size();
        Vector vector2 = new Vector();
        int n2 = 0;
        while (n2 < n) {
            vector2.add(vector.elementAt(n2));
            ++n2;
        }
        Vector vector3 = new Vector();
        while (vector2.size() > 0) {
            Vector<File> vector4 = new Vector<File>();
            File file = (File)vector2.elementAt(0);
            vector4.add(file);
            this.increaseCounter();
            vector2.remove(0);
            int n3 = 0;
            while (n3 < vector2.size()) {
                File file2 = (File)vector2.elementAt(n3);
                if (this.thread == null) {
                    return null;
                }
                if (this.fileAccess.compareFiles(file, file2)) {
                    vector4.add(file2);
                    this.increaseCounter();
                    vector2.remove(n3);
                    continue;
                }
                ++n3;
            }
            if (vector4.size() == 0) {
                System.out.println("Fehler: 'searchInnerDouble': innerVec.size() = 0");
            }
            if (vector4.size() <= 1) continue;
            vector3.add(vector4);
        }
        return vector3;
    }

    private class SortByNameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            String string = ((File)object).getName().toUpperCase();
            String string2 = ((File)object2).getName().toUpperCase();
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return true;
        }
    }
}

