/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

class FileAccess {
    JLabel progressLabel;
    JProgressBar progressBar;
    public final int EXCLUSIV = 0;
    public final int INCLUSIV = 1;
    Vector filterPrefix;
    Vector filterSuffix;
    int filterPrefixMode;
    int filterSuffixMode;
    int takenFiles;
    int totalReadFiles;
    boolean stopFlag;

    public FileAccess() {
        this.setFilter(null, null, 0, 0);
    }

    public void stopReading() {
        this.stopFlag = true;
    }

    public void setProgressLabel(JLabel jLabel) {
        this.progressLabel = jLabel;
    }

    public void setProgressBar(JProgressBar jProgressBar) {
        this.progressBar = jProgressBar;
    }

    public void setStopFlag(boolean bl) {
        this.stopFlag = bl;
    }

    public int getTotalReadFiles() {
        return this.totalReadFiles;
    }

    public int getTakenFiles() {
        return this.takenFiles;
    }

    public void resetTotalReadFiles() {
        this.totalReadFiles = 0;
    }

    public void resetTakenFiles() {
        this.takenFiles = 0;
    }

    public void increaseTotalReadFiles() {
        ++this.totalReadFiles;
        this.adjustProgress();
    }

    public void increaseTakenFiles() {
        ++this.takenFiles;
        this.adjustProgress();
    }

    public void adjustProgress() {
        int n = this.getTotalReadFiles();
        int n2 = this.getTakenFiles();
        this.progressLabel.setText("Total: " + n + " / Filtered: " + n2);
        this.progressBar.setValue((int)((double)n2 / (double)n * 100.0));
    }

    public boolean delete(File file) {
        if (!file.canWrite()) {
            String[] stringArray = new String[]{"Access denied:", "no write permission"};
            JOptionPane.showMessageDialog(null, stringArray);
            return false;
        }
        String string = "Delete - Dialog";
        String[] stringArray = new String[]{"Delete File:  ", "Path: ", " ", "Are you sure ?", " "};
        stringArray[0] = stringArray[0] + file.getName();
        stringArray[1] = stringArray[1] + file.getPath();
        int n = JOptionPane.showConfirmDialog(null, stringArray, string, 1, 2, null);
        if (n != 0) {
            return false;
        }
        boolean bl = file.delete();
        if (!bl) {
            JOptionPane.showMessageDialog(null, "Can\u00b4t delete File !");
        }
        return bl;
    }

    public void setFilter(Vector vector, Vector vector2, int n, int n2) {
        this.setFilterPrefixMode(n);
        this.setFilterPrefix(vector);
        this.setFilterSuffixMode(n2);
        this.setFilterSuffix(vector2);
    }

    public void setFilterPrefix(Vector vector) {
        this.filterPrefix = new Vector();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                this.filterPrefix.add(((String)vector.elementAt(n)).toUpperCase());
                ++n;
            }
        }
    }

    public void setFilterSuffix(Vector vector) {
        this.filterSuffix = new Vector();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                this.filterSuffix.add(((String)vector.elementAt(n)).toUpperCase());
                ++n;
            }
        }
    }

    public void setFilterPrefixMode(int n) {
        this.filterPrefixMode = n;
    }

    public void setFilterSuffixMode(int n) {
        this.filterSuffixMode = n;
    }

    private void getFiles(Vector vector, File file) {
        if (this.stopFlag) {
            return;
        }
        if (file == null || !file.canRead()) {
            return;
        }
        String string = file.getPath().toUpperCase();
        boolean bl = false;
        int n = 0;
        while (n < this.filterPrefix.size()) {
            bl = string.startsWith((String)this.filterPrefix.elementAt(n));
            if (this.filterPrefixMode == 0 && bl) {
                return;
            }
            ++n;
        }
        if (!file.isDirectory()) {
            this.increaseTotalReadFiles();
            String string2 = file.getName().toUpperCase();
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.filterSuffix.size()) {
                bl2 = string2.endsWith((String)this.filterSuffix.elementAt(n2));
                if (this.filterSuffixMode == 0 && bl2) {
                    return;
                }
                if (this.filterSuffixMode == 1 && bl2) break;
                ++n2;
            }
            if (this.filterSuffixMode == 1 && !bl2) {
                return;
            }
            this.increaseTakenFiles();
            vector.add(file);
            return;
        }
        File[] fileArray = file.listFiles();
        int n3 = 0;
        while (n3 < fileArray.length) {
            this.getFiles(vector, fileArray[n3]);
            ++n3;
        }
    }

    public Vector getAllFiles() {
        String string;
        int n;
        this.progressBar.setMaximum(100);
        this.stopFlag = false;
        this.resetTotalReadFiles();
        this.resetTakenFiles();
        Vector vector = new Vector();
        File file = new File("");
        File[] fileArray = File.listRoots();
        if (this.filterPrefixMode == 0) {
            n = 0;
            while (n < fileArray.length) {
                string = fileArray[n].getPath();
                this.getFiles(vector, fileArray[n]);
                ++n;
            }
        }
        if (this.filterPrefixMode == 1) {
            n = 0;
            while (n < this.filterPrefix.size()) {
                string = (String)this.filterPrefix.elementAt(n);
                file = new File(string);
                this.getFiles(vector, file);
                ++n;
            }
        }
        return vector;
    }

    public boolean compareFiles(File file, File file2) {
        String string;
        String string2 = file.getPath();
        if (string2.equals(string = file2.getPath())) {
            return false;
        }
        long l = 0L;
        l = file.length();
        if (l != file2.length()) {
            return false;
        }
        long l2 = 0L;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            long l3 = l / 20L;
            if (l3 < 32L) {
                l3 = 32L;
            }
            byte[] byArray = new byte[(int)l3];
            byte[] byArray2 = new byte[(int)l3];
            long l4 = 0L;
            while (l2 < l) {
                l4 = fileInputStream.read(byArray);
                fileInputStream2.read(byArray2);
                l2 += l4;
                int n = 0;
                while ((long)n < l4) {
                    if (byArray[n] != byArray2[n] || this.stopFlag) {
                        fileInputStream.close();
                        fileInputStream2.close();
                        return false;
                    }
                    ++n;
                }
            }
            fileInputStream.close();
            fileInputStream2.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception in 'compareFiles': " + exception.toString());
            System.exit(0);
            System.out.println("Fehler in 'compareFiles'");
            System.exit(0);
            return true;
        }
    }
}

