/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class FilesPanel
extends JPanel {
    FileAccess fileAccess = null;
    JList fileList;
    DefaultListModel fileListModel;
    JLabel infoLabel;
    Vector vecDoubleFiles = new Vector();

    public FilesPanel() {
        this.setLayout(new BorderLayout());
        this.fileList = new JList();
        this.fileListModel = new DefaultListModel();
        this.fileList.setModel(this.fileListModel);
        JScrollPane jScrollPane = new JScrollPane(this.fileList);
        this.infoLabel = new JLabel("");
        this.fileList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    JList jList = (JList)mouseEvent.getSource();
                    DefaultListModel defaultListModel = (DefaultListModel)jList.getModel();
                    int n = jList.locationToIndex(mouseEvent.getPoint());
                    ShowDoubleFiles showDoubleFiles = new ShowDoubleFiles(n);
                    JOptionPane.showMessageDialog(null, showDoubleFiles, "Double Files", -1);
                }
            }
        });
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.infoLabel, "South");
    }

    public void setFileAccess(FileAccess fileAccess) {
        this.fileAccess = fileAccess;
    }

    public void setDoubleFilesVector(Vector vector) {
        this.vecDoubleFiles = vector;
        this.fileListModel.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            this.fileListModel.addElement(this.getFileListEntry(vector2));
            ++n;
        }
        this.updateInfoLabel();
    }

    public void updateInfoLabel() {
        this.infoLabel.setText("# Files: " + this.vecDoubleFiles.size());
    }

    public void updateFileList(int n, Vector vector) {
        if (vector == null || vector.size() == 0) {
            this.vecDoubleFiles.remove(n);
            this.fileListModel.removeElementAt(n);
            this.updateInfoLabel();
            return;
        }
        this.vecDoubleFiles.setElementAt(vector, n);
        this.fileListModel.setElementAt(this.getFileListEntry(vector), n);
    }

    private String getFileListEntry(Vector vector) {
        Object object;
        File file = (File)((Vector)vector.elementAt(0)).elementAt(0);
        int n = 0;
        long l = Integer.MAX_VALUE;
        long l2 = 0L;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (Vector)vector.elementAt(n2);
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                ++n;
                long l3 = ((File)((Vector)object).elementAt(n3)).length();
                if (l3 < l) {
                    l = l3;
                }
                if (l3 > l2) {
                    l2 = l3;
                }
                ++n3;
            }
            ++n2;
        }
        object = "[Size:" + l;
        if (l != l2) {
            object = (String)object + "-" + l2;
        }
        object = (String)object + "]";
        return "[" + n + "x] " + file.getName() + "  " + (String)object;
    }

    class ShowDoubleFiles
    extends JPanel {
        JLabel filenameLabel;
        JButton deleteButton;
        JButton removeFileFromListButton;
        JButton removeFromFileListButton;
        JList doubleList;
        DefaultListModel doubleListModel;
        JLabel infoLabel;
        public Vector doubleListVec;

        private JList vectorToJList(Vector vector) {
            this.doubleListModel = new DefaultListModel();
            String string = "";
            int n = 0;
            while (n < vector.size()) {
                Vector vector2 = (Vector)vector.elementAt(n);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    File file = (File)vector2.elementAt(n2);
                    this.doubleListModel.addElement("[" + (n + 1) + "] " + file.getPath() + "  [Size:" + file.length() + "]");
                    ++n2;
                }
                ++n;
            }
            JList jList = new JList();
            jList.setModel(this.doubleListModel);
            return jList;
        }

        public ShowDoubleFiles(int n) {
            this.doubleListVec = (Vector)FilesPanel.this.vecDoubleFiles.elementAt(n);
            String string = ((File)((Vector)this.doubleListVec.elementAt(0)).elementAt(0)).getName().toLowerCase();
            this.filenameLabel = new JLabel(" FILE: " + string);
            this.filenameLabel.setFont(new Font("Dialog", 1, 14));
            this.deleteButton = new JButton("Delete File");
            this.removeFileFromListButton = new JButton("Remove");
            this.removeFromFileListButton = new JButton("Remove All");
            this.deleteButton.setToolTipText("Delete selected File");
            this.removeFileFromListButton.setToolTipText("Remove selected items from list (without deleting file)");
            this.removeFromFileListButton.setToolTipText("Remove all items from list (without deleting files)");
            this.doubleList = this.vectorToJList(this.doubleListVec);
            this.doubleList.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.doubleList);
            this.infoLabel = new JLabel("");
            this.updateInfoLabel();
            this.deleteButton.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$doubleFilesIndex;
                private final /* synthetic */ ShowDoubleFiles this$1;
                {
                    this.this$1 = showDoubleFiles;
                    this.val$doubleFilesIndex = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.doubleList.getSelectedIndex();
                    boolean bl = this.this$1.removeDoubleListElementAt(this.val$doubleFilesIndex, n, false);
                    if (this.this$1.getNumberOfFiles() == 0) {
                        this.this$1.clearPanel();
                    }
                    this.this$1.updateInfoLabel();
                }
            });
            this.removeFromFileListButton.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$doubleFilesIndex;
                private final /* synthetic */ ShowDoubleFiles this$1;
                {
                    this.this$1 = showDoubleFiles;
                    this.val$doubleFilesIndex = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowDoubleFiles.access$000(this.this$1).updateFileList(this.val$doubleFilesIndex, null);
                    this.this$1.clearPanel();
                }
            });
            this.removeFileFromListButton.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ int val$doubleFilesIndex;
                private final /* synthetic */ ShowDoubleFiles this$1;
                {
                    this.this$1 = showDoubleFiles;
                    this.val$doubleFilesIndex = n;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = this.this$1.doubleList.getSelectedIndex();
                    boolean bl = this.this$1.removeDoubleListElementAt(this.val$doubleFilesIndex, n, true);
                    if (this.this$1.getNumberOfFiles() == 0) {
                        this.this$1.clearPanel();
                    }
                    this.this$1.updateInfoLabel();
                }
            });
            this.setPreferredSize(new Dimension(400, 200));
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)this.filenameLabel, "North");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0));
            jPanel2.add(this.deleteButton);
            jPanel2.add(this.removeFileFromListButton);
            jPanel2.add(this.removeFromFileListButton);
            jPanel.add((Component)jPanel2, "Center");
            this.add((Component)jPanel, "North");
            this.add((Component)jScrollPane, "Center");
            this.add((Component)this.infoLabel, "South");
        }

        public void clearPanel() {
            this.removeAll();
            JLabel jLabel = new JLabel("No Entries  (Press OK)");
            jLabel.setFont(new Font(null, 1, 16));
            this.add((Component)jLabel, "North");
            this.repaint();
            this.validate();
        }

        public void updateInfoLabel() {
            this.infoLabel.setText("# Files: " + this.getNumberOfFiles() + "     # of not common Files: " + this.doubleListVec.size());
        }

        public int getNumberOfFiles() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.doubleListVec.size()) {
                Vector vector = (Vector)this.doubleListVec.elementAt(n2);
                if (vector.size() == 0) {
                    System.out.println("'getNumberOfFiles': innerVec.size()=0");
                }
                n += vector.size();
                ++n2;
            }
            return n;
        }

        public boolean removeDoubleListElementAt(int n, int n2, boolean bl) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.doubleListVec.size()) {
                Vector vector = (Vector)this.doubleListVec.elementAt(n4);
                int n5 = 0;
                while (n5 < vector.size()) {
                    if (n3 == n2) {
                        File file = (File)vector.elementAt(n5);
                        if (bl || FilesPanel.this.fileAccess.delete(file)) {
                            vector.remove(n5);
                            if (vector.size() == 0) {
                                this.doubleListVec.remove(n4);
                                --n4;
                            }
                            this.doubleListModel.removeElementAt(n2);
                            FilesPanel.this.updateFileList(n, this.doubleListVec);
                            return true;
                        }
                        return false;
                    }
                    ++n3;
                    ++n5;
                }
                ++n4;
            }
            return false;
        }

        static /* synthetic */ FilesPanel access$000(ShowDoubleFiles showDoubleFiles) {
            return showDoubleFiles.FilesPanel.this;
        }
    }
}

