/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class ListInputPanel
extends JPanel {
    JButton removeButton = new JButton("Remove");
    JButton clearButton = new JButton("Clear");
    JButton addButton = new JButton("Add");
    JList list = new JList();
    DefaultListModel listModel = new DefaultListModel();
    JToggleButton modeButton = new JToggleButton("Exclusiv");
    public int modeValue = 0;

    public ListInputPanel(String string) {
        this.setBorder(BorderFactory.createTitledBorder(string));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        this.removeButton.setFont(new Font(null, 1, 10));
        this.removeButton.setToolTipText("Remove selected Items from List");
        this.clearButton.setFont(new Font(null, 1, 10));
        this.clearButton.setToolTipText("Remove all Items from the List");
        this.addButton.setFont(new Font(null, 1, 10));
        this.addButton.setToolTipText("Add a new Item to List");
        this.modeButton.setToolTipText("Set how to handle the List Entries");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListInputPanel.this.removeButtonPressed();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListInputPanel.this.clearButtonPressed();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListInputPanel.this.addButtonPressed();
            }
        });
        this.modeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListInputPanel.this.modeButtonPressed();
            }
        });
        jPanel.add(this.removeButton);
        jPanel.add(this.clearButton);
        jPanel.add(this.addButton);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)this.modeButton, "South");
        this.list.setModel(this.listModel);
    }

    public Vector listToVector() {
        Vector vector = new Vector();
        Enumeration enumeration = this.listModel.elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public int getMode() {
        return this.modeValue;
    }

    public void addToList(String string) {
        this.listModel.addElement(string);
    }

    public void removeFromList(int n) {
        this.listModel.removeElementAt(n);
    }

    public void removeButtonPressed() {
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            this.removeFromList(nArray[n] - n);
            ++n;
        }
    }

    public void clearButtonPressed() {
        this.listModel.removeAllElements();
    }

    public void addButtonPressed() {
    }

    public void modeButtonPressed() {
        this.modeValue = this.modeButton.isSelected() ? 1 : 0;
        if (this.modeValue == 0) {
            this.modeButton.setText("Exclusiv");
        }
        if (this.modeValue == 1) {
            this.modeButton.setText("Inclusiv");
        }
    }
}

