/*
 * Created on 26.01.2005 13:21:56
 *
 * TITLE:
 */
package idea;

import java.util.Random;

/**
 * Description
 * 
 * @author Markus Krebs
 */
public class IDEA {
	public static int ENCRYPT = 0;
	public static int DECRYPT = 1;
	
	public long[] key128 = new long[8];
	private long[] subkeys = new long[52];
	
	public final long and = 0xFFFF;
	
	private Random random;

	// This function makes a idea-multiplication, that means, a
	// multiplication modulo 65537. Zero (a or b) is seen as
	// 65536.
	private long mul(long a, long b) {
		if(a==0) return (1-b)&and;
		if(b==0) return (1-a)&and;
		return ((a*b)%65537)&and;
	}
	private long add(long a, long b) {
		return (a+b)&and;
	}
	private long xor(long a, long b) {
		return (a^b)&and;
	}
	// This function calculates the multiplicative inverse of x,
	// modulo 65537, using Euclid's algorithm. Not from me!
	private long mulInv(long x) {
		long t0,t1,q,y;

		if(x <= 1) return x&and;
		t1 = (0x10001 / x)&and;
		y =  (0x10001 % x)&and;
		if(y == 1) return ((1-t1)&and);
		t0 = 1;
		do {
			q = (x / y)&and;
			x = (x % y)&and;
			t0 = (t0+(q * t1)&and)&and;
			if(x == 1) return t0;
			q = (y / x)&and;
			y = (y % x)&and;
			t1 = (t1 + (q * t0)&and)&and;	
		} while(y != 1);
		return ((1-t1)&and);
	}
	private long addInv(long x) {
 		return (-x)&and;
 	}
	private int[] DecryptKeyPerm_table = new int[] {
			48,49,50,51,46,47,
			42,44,43,45,40,41,
			36,38,37,39,34,35,
			30,32,31,33,28,29,
			24,26,25,27,22,23,
			18,20,19,21,16,17,
			12,14,13,15,10,11,
			6, 8, 7, 9, 4, 5,
			0, 1, 2, 3
	};
	// Rotates a 128-bit value 25-bit leftward
	private void Rot25L(long[] x) {
		long[] k = new long[8];
		// oberen 9 bits von [1], unteren 7 bits von [0] etc.
		k[0] = (x[1]>>7)&and + ((x[0]&127)<<9)&and;
		k[1] = (x[0]>>7)&and + ((x[7]&127)<<9)&and;
		k[2] = (x[7]>>7)&and + ((x[6]&127)<<9)&and;
		k[3] = (x[6]>>7)&and + ((x[5]&127)<<9)&and;
		k[4] = (x[5]>>7)&and + ((x[4]&127)<<9)&and;
		k[5] = (x[4]>>7)&and + ((x[3]&127)<<9)&and;
		k[6] = (x[3]>>7)&and + ((x[2]&127)<<9)&and;
		k[7] = (x[2]>>7)&and + ((x[1]&127)<<9)&and;
		for(int i=0;i<8;++i) x[i] = k[i]&and;
	}
	// This function generates the encryption Keys.
	// These keys are also used to create the decryption
	// keys, but therefor they had to be transformed
	private void normKeys(long[] key) {
		int i;
		long[] k = new long[8];
		for(i=0;i<8;++i) k[i] = subkeys[i] = key[i];
		for(;i<52;++i) {
			if((i&7) == 0) Rot25L(k);
			subkeys[i] = k[i&7];
		}
	}
	// This function generates from the key (128-bit) 52 subkeys.
	// The variable 'key' have to polong on a 128-bit key.
	public void generateKeys(long[] key, long mode) {
		long[] x = new long[52];
		int i;
		normKeys(key);                // creates the subkeys (encryption)
		if(mode == ENCRYPT) return;
		else if(mode == DECRYPT) {
			for(i=0;i<52;++i) x[i] = subkeys[DecryptKeyPerm_table[i]];
			for(i=0;i<52;i+=6) {
				subkeys[i]   = mulInv(x[i]);
				subkeys[i+1] = addInv(x[i+1]); //(-x[i+1])&and;
				subkeys[i+2] = addInv(x[i+2]); //(-x[i+2])&and;
				subkeys[i+3] = mulInv(x[i+3]);
				if(i+4<52) subkeys[i+4] = x[i+4];
				if(i+5<52) subkeys[i+5] = x[i+5];
			}
		}
	}
	// This function crypts (en/de - idea_generateKeys must be called) a 64-bit block,
	// on which 'data' have to polong.
	public void cryptBlock(long[] data) {
		long t1,t2,t3,t4,t5,t6,t7,t8,t9,t10;
		int k;
		// 8 rounds, in every round 6 keys -> 6*8 = 48
		for(k=0;k<48;k+=6) {
			t1      = mul(data[0], subkeys[k+0]);
			t2      = add(data[1], subkeys[k+1]);
			t3      = add(data[2], subkeys[k+2]);
			t4      = mul(data[3], subkeys[k+3]);
			t5      = xor(t1, t3);
			t6      = xor(t2, t4);
			t7      = mul(t5, subkeys[k+4]);
			t8      = add(t6, t7);
			t9      = mul(t8, subkeys[k+5]);
			t10     = add(t7, t9);
			data[0] = xor(t1, t9);
			data[1] = xor(t3, t9);
			data[2] = xor(t2, t10);
			data[3] = xor(t4, t10);
		}
		t1 = data[1]; data[1] = data[2]; data[2] = t1;     // letzte Runde nochmals vertauschen

		data[0] = mul(data[0], subkeys[k+0]);
		data[1] = add(data[1], subkeys[k+1]);
		data[2] = add(data[2], subkeys[k+2]);
		data[3] = mul(data[3], subkeys[k+3]);
	}
}
