/*
 * Created on 19.01.2005 20:29:48
 *
 * TITLE: Ciphering ByteArrays with IDEA
 */
package idea;

import java.util.Random;
/**
 * IDEACryptByteArray
 * 
 * @author Markus Krebs
 */
public class IDEACryptByteArray extends IDEA {
	
	private Random random;

	public void setPassword(String password) {
		if(password.equals("")) {
			// Bei Return-Passwort alles auf 0 setzen
			for(int i=0; i<8; i++) key128[i] = 0;
			return;
		}
		byte[] b = password.getBytes();
		long[] pw = new long[16];
		int slen=b.length;
		int by;
		for(int i=0; i<Math.max(slen,16); i++) {
			by = (int)b[i%slen]; if(by<0) by+=256;
			if(i<16) pw[i] = by&0xFF;
			else pw[i%16] = (pw[i%16] + by)&0xFF;
		}
		for(int i=0; i<8; i++) key128[i] = pw[i*2]*0x100+pw[i*2+1];
	}

	public byte[] encrypt(byte[] in) {
		generateKeys(key128, IDEA.ENCRYPT);
		// Betriebsart: CBC (Cipher Block Chaining)
		random = new Random(System.currentTimeMillis());
		int pos = 0;
		int len = in.length;
		long[] oldBlock = new long[4];
		long[] block = new long[4];
		int outsize = len+8;
		if(len%8!=0) outsize+=(8-len%8)+8;	// Letzter Block fllen + Lnge-Block
		else outsize +=8;			// Lnge-Block
		byte[] out = new byte[outsize];
		
		// Initialisierungs-Vektor
		long tm = System.currentTimeMillis();
		block[0] = (tm>>16)&and;
		block[1] = tm&and;
		block[2] = random.nextInt(65536);
		block[3] = random.nextInt(65536);
		cryptBlock(block);
		pos += writeBlock(block, out, pos);
		
		while(pos<len+8) {	// +8 da IV dazu kommt
			copyBlock(block, oldBlock);	// Alten Block fr CBC vermerken
			getBlock(block, in, pos-8);	// -8 da IV
			xorBlock(block, oldBlock);	// CBC
			cryptBlock(block);
			pos += writeBlock(block, out, pos);
		}
		copyBlock(block, oldBlock);
		
		for(int i=0; i<4; i++) block[i] = random.nextInt(65536);
		int lastLen = 0;
		if(len%8!=0) lastLen = len%8;
		block[3] = (block[3]&0xFFF8) + (long)lastLen;
		
		xorBlock(block, oldBlock);
		cryptBlock(block);
		pos += writeBlock(block, out, pos);
		
		return out;
	}
	public byte[] decrypt(byte[] in) {
		generateKeys(key128,IDEA.DECRYPT);
		// Betriebsart: CBC (Cipher Block Chaining)
		int pos = 0;
		int len = in.length;
		long[] oldBlock = new long[4];
		long[] oldBlock2 = new long[4];
		long[] block = new long[4];		
		byte[] out = new byte[len];
		// Initialisierungsvektor
		getBlock(block, in, pos);
		pos += writeBlock(block, out, pos);
		copyBlock(block, oldBlock2);	// crypt-block vermerken
		// Daten + Lnge-Block
		while(pos<len) {
			copyBlock(oldBlock2, oldBlock);	// Alten Block fr CBC vermerken
			getBlock(block, in, pos);
			// hier Block vermerken (da immer mit kryptographiertem Block ge-xor-t werden muss!)
			copyBlock(block, oldBlock2);
			cryptBlock(block);
			xorBlock(block, oldBlock);	// CBC
			pos += writeBlock(block, out, pos);
		}
		int lastLen = (int)(block[3]&7);
		int newsize = len-16;	// IV und Lnge-Block mssen weg
		if(lastLen!=0) newsize = newsize-8+lastLen;	// vom letzten Block nur lastLen-Bytes holen
		byte[] newout = new byte[newsize];
		System.arraycopy(out, 8, newout, 0, newsize);	// IV nicht kopieren
		return newout;
	}
	private void getBlock( long[] block, byte[] in, int pos) {
		int len = in.length;
		int posi2, low, high;
		if(len-pos>=8) {
			// Voller Block vorhanden
			for(int i=0; i<4; i++) {
				posi2 = pos+i*2;
				high = (int)in[posi2]; if(high<0) high+=256;
				low = (int)in[posi2+1]; if(low<0) low+=256;
				block[i] = high*0x100 + low;
			}
		}
		else {
			// Kein voller Block mehr vorhanden => mit Zufallswerten auffllen
			for(int i=0; i<4; i++) {
				posi2 = pos+i*2;
				if(posi2<len) { high = (int)in[posi2]; if(high<0) high+=256; }
				else			high = random.nextInt(256);
				if(posi2+1<len) {	low = (int)in[posi2+1]; if(low<0) low+=256; }
				else				low = random.nextInt(256);
				block[i] = high*0x100 + low;
			}
		}
	}
	private int writeBlock(long[] block, byte[] out, int pos) {
		int posi2;
		for(int i=0; i<4; i++) {
			posi2 = pos+i*2;
			out[posi2] = (byte)(block[i]/0x100);
			out[posi2+1] = (byte)(block[i]%0x100);
		}
		return 8;
	}
	// wird fr CBC bentigt
	private void copyBlock(long[] block, long[] copy) {
		for(int i=0; i<4; i++) copy[i] = block[i];
	}
	// wird fr CBC bentigt
	private void xorBlock(long[] block, long[] xorblock) {
		for(int i=0; i<4; i++) block[i] = (block[i]^xorblock[i])&and;
	}
	public String dataOut(byte[] b) {
		System.out.println("DATA.length: "+b.length+" Bytes");
		String s = new String(b);
		System.out.print("DATA.hex:    ");
		String hex = "";
		StringBuffer buf = new StringBuffer();
		// Hchstens 100 Bytes im HEX-Format ausgeben
		for(int i=0; i<Math.min(100, b.length); i++) {
			int by = (int)b[i]; if(by<0) by+=256;
			hex = Integer.toHexString(by);
			if(hex.length()<2) hex = "0"+hex;
			buf.append(hex);
			if(i%2==1) buf.append(" ");
		}
		System.out.println(buf);
		if(s.length()>1000) s = s.substring(0,1000);
		// Nicht ausgebbare Zeichen durch _ ersetzen
		for(int i=0; i<32; i++) s = s.replace((char)i,'_');
		System.out.println("DATA.string: "+s);
		return s;
	}
	
	public IDEACryptByteArray() {
	}		
}