/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.rtf.RTFEditorKit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class PrintManager
extends JFrame {
    private RTFEditorKit rtfEditorKit = new RTFEditorKit();
    private byte[] fileBytes;
    private String fileType;
    private PrintJob printJob;
    private int pageWidth;
    private int pageHeight;
    private int btop = 30;
    private int bleft = 50;
    private int bbottom = 70;
    private int bright = 40;
    private Insets border = new Insets(this.btop, this.bleft, this.bbottom, this.bright);
    private JPanel pagePreview;
    private JTabbedPane tabbedPane;
    private Vector pages;

    private void a(String string) {
        System.out.println(string);
    }

    public PrintManager(JTextPane jTextPane, String string) {
        Object object;
        Object object2;
        this.a("PrintManager started.");
        if (!string.toLowerCase().equals("rtf")) {
            this.a("File type '" + string + "' currently not supported.");
            this.a("PrintManager exited");
            return;
        }
        this.fileBytes = null;
        try {
            object2 = new ByteArrayOutputStream();
            object = jTextPane.getDocument();
            this.rtfEditorKit.write((OutputStream)object2, (Document)object, 0, object.getLength());
            this.fileBytes = ((ByteArrayOutputStream)object2).toByteArray();
            ((ByteArrayOutputStream)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.fileBytes == null) {
            JOptionPane.showMessageDialog(null, "Can't transform Text to Bytes (via ByteArrayOutputStream)!!\n=> can't print !");
            return;
        }
        if (!this.int()) {
            this.a("Printing aborted.");
            this.if();
            return;
        }
        this.setTitle("PrintManager V1.0 by Markus Krebs");
        this.fileBytes = this.fileBytes;
        this.fileType = string.toLowerCase();
        object2 = this.getContentPane();
        ((Container)object2).setLayout(new BorderLayout());
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(0));
        JButton jButton = new JButton("Exit");
        jButton.setBorder(BorderFactory.createEtchedBorder());
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.if();
            }
        });
        ((Container)object).add(jButton);
        JButton jButton2 = new JButton("Print");
        jButton2.setBorder(BorderFactory.createEtchedBorder());
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintManager.this.do();
            }
        });
        ((Container)object).add(jButton2);
        JButton jButton3 = new JButton("Page Dimensions -> ToolTips");
        jButton3.setBorder(BorderFactory.createEtchedBorder());
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = 0;
                while (n2 < PrintManager.this.pages.size()) {
                    JTextPane jTextPane = (JTextPane)PrintManager.this.pages.elementAt(n2);
                    String string = jTextPane.getWidth() + "x" + jTextPane.getHeight();
                    PrintManager.this.tabbedPane.setToolTipTextAt(n2, string);
                    ++n2;
                }
            }
        });
        ((Container)object).add(jButton3);
        JLabel jLabel = new JLabel("Printer: " + this.pageWidth + "x" + this.pageHeight);
        jLabel.setBorder(BorderFactory.createEtchedBorder());
        ((Container)object).add(jLabel);
        ((Container)object2).add((Component)object, "North");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PrintManager.this.if();
            }
        });
        this.pagePreview = new JPanel();
        this.pagePreview.setLayout(new BorderLayout());
        ((Container)object2).add((Component)this.pagePreview, "Center");
        this.setBounds(40, 40, this.pageWidth + 16, 450);
        this.tabbedPane = new JTabbedPane(1);
        this.pagePreview.add((Component)this.tabbedPane, "Center");
        this.setVisible(true);
        this.a();
        this.setBounds(40, 40, this.pageWidth + 31, 450);
        this.validate();
    }

    public boolean int() {
        this.printJob = this.getToolkit().getPrintJob(this, "PrinterTest", null);
        if (this.printJob != null) {
            Dimension dimension = this.printJob.getPageDimension();
            this.pageWidth = dimension.width;
            this.pageHeight = dimension.height;
            return true;
        }
        return false;
    }

    public void if() {
        if (this.printJob != null) {
            this.printJob.end();
        }
        this.hide();
        this.a("PrintManager exited.");
    }

    public void do() {
        if (this.printJob == null) {
            JOptionPane.showMessageDialog(null, "PrintJob = null !!!\nCan't print !");
            return;
        }
        if (this.printJob != null) {
            this.a("Printing (" + this.pages.size() + " pages):");
            Enumeration enumeration = this.pages.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                this.a("  Page " + ++n2);
                JTextPane jTextPane = (JTextPane)enumeration.nextElement();
                Graphics graphics = this.printJob.getGraphics();
                if (graphics == null) continue;
                jTextPane.paint(graphics);
                graphics.dispose();
            }
            this.a("end of print.");
        }
    }

    private JTextPane for() {
        JTextPane jTextPane = new JTextPane();
        EditorKit editorKit = jTextPane.getEditorKit();
        jTextPane.setText("");
        if (this.fileType.equals("rtf")) {
            jTextPane.setEditorKit(this.rtfEditorKit);
        } else {
            jTextPane.setEditorKit(editorKit);
        }
        try {
            Document document = jTextPane.getDocument();
            if (this.fileType.equals("rtf")) {
                this.rtfEditorKit.read(new ByteArrayInputStream(this.fileBytes), document, 0);
            } else {
                editorKit.read(new ByteArrayInputStream(this.fileBytes), document, 0);
            }
        }
        catch (Exception exception) {
            this.a("ERROR: Can't create JTextPane!");
            exception.printStackTrace();
            return null;
        }
        return jTextPane;
    }

    private void a() {
        this.a("Generate Pages");
        this.pages = new Vector();
        JTextPane jTextPane = this.for();
        jTextPane.setEditable(false);
        jTextPane.setMargin(this.border);
        this.tabbedPane.add("Page 1", new JScrollPane(jTextPane));
        this.pages.add(jTextPane);
        this.validate();
        this.a("width=" + jTextPane.getWidth());
        Document document = jTextPane.getDocument();
        int n2 = document.getLength();
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        int n4 = -1;
        int n5 = this.pageHeight - this.bbottom;
        int n6 = 0;
        while (n6 < n2) {
            Rectangle rectangle = null;
            try {
                rectangle = jTextPane.modelToView(n6);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return;
            }
            if (rectangle == null) {
                this.a("  r=null!");
                return;
            }
            if (rectangle.x < n4 && rectangle.y + rectangle.height > n5) {
                n5 = rectangle.y + this.pageHeight - this.bbottom - this.btop;
                vector.add(new Integer(n6));
                ++n3;
            }
            n4 = rectangle.x;
            ++n6;
        }
        vector.add(new Integer(n2));
        this.a("  # of Pages: " + vector.size());
        int n7 = 0;
        int n8 = 0;
        Enumeration enumeration = vector.elements();
        n3 = 1;
        while (enumeration.hasMoreElements()) {
            this.a("  Page " + n3);
            n8 = (Integer)enumeration.nextElement();
            try {
                if (n8 < n2) {
                    document.remove(n8, n2 - n8);
                }
                if (n7 > 0) {
                    document.remove(0, n7 - 1);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            if (n8 == n2) break;
            n7 = n8;
            jTextPane = this.for();
            document = jTextPane.getDocument();
            jTextPane.setEditable(false);
            jTextPane.setMargin(this.border);
            this.tabbedPane.add("Page " + ++n3, new JScrollPane(jTextPane));
            this.pages.add(jTextPane);
        }
        this.a("-> Pages ready to print.");
        Runtime runtime = Runtime.getRuntime();
        this.a("Total Memory: " + runtime.totalMemory());
        this.a("Free Memory:  " + runtime.freeMemory());
    }
}

