/*****************************************************************
  Konvertierungsmethoden fr das Calendar-Objekt
                         12.03.2002 20:03
*****************************************************************/
import java.util.*;
class CalendarUtils {
  Calendar calendarTemplate = null;
  // Aktuelles Jahr ermitteln
  public static int getActualYear() {
    Calendar calendar = Calendar.getInstance();
    return calendar.get(Calendar.YEAR);
  }
  // Wochentag zurckgeben
  public static String calendarWeekDay(Calendar calendar) {
    int d = calendar.get(Calendar.DAY_OF_WEEK);
    if(d==Calendar.SUNDAY) return "SO";
    if(d==Calendar.MONDAY) return "MO";
    if(d==Calendar.TUESDAY) return "DI";
    if(d==Calendar.WEDNESDAY) return "MI";
    if(d==Calendar.THURSDAY) return "DO";
    if(d==Calendar.FRIDAY) return "FR";
    if(d==Calendar.SATURDAY) return "SA";
    return "FEHLER";
  }
  // Wandelt den Datums- und Zeit-String in eine Calendar-Objekt um
  public static Calendar toCalendar(String date, String time) {
    int day    = Integer.parseInt(date.substring(0, 2));
    int month  = Integer.parseInt(date.substring(3, 5));
    int year   = Integer.parseInt(date.substring(6,10));
    int hour   = Integer.parseInt(time.substring(0, 2));
    int minute = Integer.parseInt(time.substring(3, 5));

    Calendar calendar = Calendar.getInstance();
    calendar.set(year, month-1, day, hour, minute, 0);
    return calendar;
  }
  // 2 Calendar-Objekte vergleichen
  // Achtung: Die Calendar.equals-Funktion funktioniert nicht, da
  //          jedes Objekt neu mit anderen verschiedenen Parametern
  //          instanziiert wird (Calendar.getInstance())
  public static boolean calendarEquals(Calendar c1, Calendar c2) {
    // 1. Objekt
    int year1   = c1.get(Calendar.YEAR);
    int month1  = c1.get(Calendar.MONTH);
    int day1    = c1.get(Calendar.DAY_OF_MONTH);
    int hour1   = c1.get(Calendar.HOUR_OF_DAY);
    int minute1 = c1.get(Calendar.MINUTE);
    // 2. Objekt
    int year2   = c2.get(Calendar.YEAR);
    int month2  = c2.get(Calendar.MONTH);
    int day2    = c2.get(Calendar.DAY_OF_MONTH);
    int hour2   = c2.get(Calendar.HOUR_OF_DAY);
    int minute2 = c2.get(Calendar.MINUTE);
    // Vergleich
    return (minute1==minute2)&&(hour1==hour2)&&
           (day1==day2)&&(month1==month2)&&(year1==year2);
  }
  // Calendar-Datum in String umwandeln (dd.mm.yyyy)
  public static String calendarDate(Calendar calendar) {
    String year   = calendar.get(Calendar.YEAR)+"";
    String month  = fillZeros((calendar.get(Calendar.MONTH)+1)+"");
    String day    = fillZeros(calendar.get(Calendar.DAY_OF_MONTH)+"");
    return day+"."+month+"."+year;
  }
  // Calendar-Datum in String umwandeln (yyyy.mm.dd)
  public static String calendarDateReverse(Calendar calendar) {
    String year   = calendar.get(Calendar.YEAR)+"";
    String month  = fillZeros((calendar.get(Calendar.MONTH)+1)+"");
    String day    = fillZeros(calendar.get(Calendar.DAY_OF_MONTH)+"");
    return year+"."+month+"."+day;
  }
  // Calendar-Zeit in String umwandeln (hh:mm)
  public static String calendarTime(Calendar calendar) {
    String hour   = fillZeros(calendar.get(Calendar.HOUR_OF_DAY)+"");
    String minute = fillZeros(calendar.get(Calendar.MINUTE)+"");
    return hour+":"+minute;
  }
  private static String fillZeros(String s) {
    if(s.length()==1) return "0"+s;
    else return s;
  }
} // finish class CalendarConverter
