/*
 * Created on 29.01.2005 14:03:13
 *
 * TITLE: ZipTool
 */
package ziptool;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import java.util.zip.ZipEntry;

/**
 * Zippen von byte-Arrays
 * 
 * @author Markus Krebs
 */
public class ZipTool {
		
	private static String filename = "$";
	
	/**
	 * Sets the filename for the zip-Method
	 * @param fn filename
	 */
	public static void setFilename(String fn) { filename = fn; }
	/**
	 * Returns the filename after executing the unzip-Method
	 * @return filename
	 */
	public static String getFilename() { return filename; }

	/**
	 * Zips a byte-array and give a zip byte-array back. Please set a filename before calling
	 * this method.
	 * @param in the byte-array to zip
	 * @return the zipped byte-array
	 * @see ZipTool.setFilename()
	 */
	public static byte[] zip(byte[] in) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ZipOutputStream zos = new ZipOutputStream(baos);
		ZipEntry ze;
		try {
			ze = new ZipEntry(filename);
			ze.setSize(in.length);
			zos.putNextEntry(ze);
			zos.write(in);
			zos.closeEntry();
			zos.close();
		}
		catch(Exception ex) { ex.printStackTrace(); }
		return baos.toByteArray();
	}
	/**
	 * Unzips a byte-array and give a unzipped byte-array back. The filename can retrieved by
	 * the ZipTool.getFilename()-Method.
	 * @param in the byte-array to zip
	 * @return the zipped byte-array
	 * @see ZipTool.getFilename()
	 */
	public static byte[] unzip(byte[] in) {
		ByteArrayInputStream bais = new ByteArrayInputStream(in);
		ZipInputStream zis = new ZipInputStream(bais);
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		ZipEntry ze;
		int blockLen = 512;
		byte[] block = new byte[blockLen];
		try {
			ze = zis.getNextEntry();
			filename = ze.getName();
			int c =0;
			while((c=zis.read(block, 0, blockLen))>=0)
				baos.write(block, 0, c); 
			zis.close();
			baos.close();
		}
		catch(Exception ex) { ex.printStackTrace(); }
		return baos.toByteArray();
	}
}
