/*
 * Created on 29.01.2005 14:53:31
 *
 * TITLE: ZipToolTest
 */
package ziptool;

import java.util.Arrays;

/**
 * Testen des ZipTools
 * 
 * @author Markus Krebs
 */
public class ZipToolTest {

	public static boolean DEBUG = true;

	public static void main(String[] args) {
		String str = "Markus Krebs\nBrunnenstr.4\nD-79400 Kandern-Holzen";
		for(int i=0; i<15; i++) str+=str;
		byte[] in = str.getBytes();
		
		if(DEBUG) System.out.println("original-length: "+in.length);
		
		ZipTool.setFilename("file.txt");
		byte[] out = ZipTool.zip(in);
		
		if(DEBUG) {
			System.out.println("zipped-length: "+out.length);
			//System.out.println("zipped: "+new String(out));
			//System.out.println();
			//for(int i=0; i<out.length; i++) System.out.print(out[i]+" ");
			//System.out.println();
		}
		
		out = ZipTool.unzip(out);
		String filename = ZipTool.getFilename();
		
		if(DEBUG) {
			System.out.println("unzipped-filename: "+filename);
			System.out.println("unzipped-length: "+out.length);
			System.out.println("in == out: "+Arrays.equals(in,out));
			//System.out.println("unzipped: "+new String(out));
		}
	}
}
